/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.parser.visitor;

import com.huawei.hwclouds.migration.common.util.ConvertUtil;
import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import com.huawei.hwclouds.migration.td.nodes.FromSpec;
import com.huawei.hwclouds.migration.td.nodes.JoinJoinedSpec;
import com.huawei.hwclouds.migration.td.nodes.JoinSourceSpec;
import com.huawei.hwclouds.migration.td.parser.TeradataParser;
import com.huawei.hwclouds.migration.td.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.JoinJoinedSpecVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.JoinSourceSpecVisitor;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FromSpecVisitor
extends AbstractVisitor<FromSpec> {
    private static final Logger logger = LogManager.getLogger(FromSpecVisitor.class);
    FromSpec result = new FromSpec();

    @Override
    protected FromSpec defaultResult() {
        return this.result;
    }

    @Override
    public FromSpec visitFromSpec(TeradataParser.FromSpecContext ctx) {
        if (ctx.joinSourceSpec() != null) {
            this.result.setJoinSourceSpec((JoinSourceSpec)new JoinSourceSpecVisitor().visit((ParseTree)ctx.joinSourceSpec()));
        } else if (ctx.fromSpec() != null) {
            this.result.setFromSpecWithBrackets((FromSpec)new FromSpecVisitor().visit((ParseTree)ctx.fromSpec()));
        } else {
            if (ctx.fromPivotSpec() != null) {
                logger.error("from clause is not supported,context:[{}]", (Object)ConvertUtil.positionInfo(ctx.fromPivotSpec()));
                throw new ParserRuntimeException("DSC not support to visit with fromPivotSpec");
            }
            if (ctx.fromUnpivotSpec() != null) {
                logger.error("from clause is not supported,context:[{}]", (Object)ConvertUtil.positionInfo(ctx.fromUnpivotSpec()));
                throw new ParserRuntimeException("DSC not support to visit with fromUnpivotSpec");
            }
            logger.error("from clause is incomplete,context:[{}]", (Object)ConvertUtil.positionInfo(ctx));
            throw new ParserRuntimeException("From clause is incomplete");
        }
        if (ctx.joinJoinedSpec() != null) {
            ArrayList<JoinJoinedSpec> joinJoinedSpecList = new ArrayList<JoinJoinedSpec>();
            ctx.joinJoinedSpec().forEach(joinJoinedSpec -> joinJoinedSpecList.add((JoinJoinedSpec)new JoinJoinedSpecVisitor().visit((ParseTree)joinJoinedSpec)));
            this.result.setJoinJoinedSpecList(joinJoinedSpecList);
        }
        return this.result;
    }
}

