/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.parser.visitor;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.td.nodes.Expression;
import com.huawei.hwclouds.migration.td.nodes.OrderBySpecification;
import com.huawei.hwclouds.migration.td.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.td.nodes.WindowSpec;
import com.huawei.hwclouds.migration.td.parser.TeradataParser;
import com.huawei.hwclouds.migration.td.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.td.parser.visitor.OrderBySpecificationVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class WindowSpecVisitor
extends AbstractVisitor<WindowSpec> {
    WindowSpec result = new WindowSpec();

    @Override
    protected WindowSpec defaultResult() {
        return this.result;
    }

    @Override
    public WindowSpec visitWindowSpec(TeradataParser.WindowSpecContext ctx) {
        this.visitPartitionOrder(ctx.windowPartitionBy(), ctx.windowOrderBy());
        if (ctx.windowRows() != null) {
            StringBuilder sb = new StringBuilder();
            int childCount = ctx.windowRows().getChildCount();
            for (int i = 0; i < childCount; ++i) {
                sb.append(ctx.windowRows().getChild(i).getText());
                if (i == childCount - 1) continue;
                sb.append(" ");
            }
            this.result.setWithRows(sb.toString());
        }
        return this.result;
    }

    private void visitPartitionOrder(TeradataParser.WindowPartitionByContext windowPartitionByContext, TeradataParser.WindowOrderByContext windowOrderByContext) {
        if (windowPartitionByContext != null) {
            SqlNodeList<Expression> windowPartitionByList = new SqlNodeList<Expression>();
            windowPartitionByContext.expression().forEach(expressionContext -> windowPartitionByList.addNode((Expression)new ExpressionVisitor().visit((ParseTree)expressionContext)));
            this.result.setWindowPartitionByList(windowPartitionByList);
        }
        if (windowOrderByContext != null) {
            SqlNodeList<OrderBySpecification> orderBySpecificationList = new SqlNodeList<OrderBySpecification>();
            windowOrderByContext.orderBySpecification().forEach(orderBySpecificationContext -> orderBySpecificationList.addNode((OrderBySpecification)new OrderBySpecificationVisitor().visit((ParseTree)orderBySpecificationContext)));
            this.result.setOrderBySpecificationList(orderBySpecificationList);
        }
    }

    @Override
    public WindowSpec visitWindowSpecWithoutRows(TeradataParser.WindowSpecWithoutRowsContext ctx) {
        this.visitPartitionOrder(ctx.windowPartitionBy(), ctx.windowOrderBy());
        return this.result;
    }

    @Override
    public WindowSpec visitWindowSpecWithTies(TeradataParser.WindowSpecWithTiesContext ctx) {
        if (ctx.withTies() != null) {
            throw new ParserRuntimeException(ParserExceptionDef.DSC_NOT_SUPPORT, "over(with ties)");
        }
        this.visitPartitionOrder(ctx.windowPartitionBy(), ctx.windowOrderBy());
        return this.result;
    }
}

