/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.ColumnPartitionDefinitionItem;
import com.huawei.hwclouds.migration.td.nodes.TableConstraint;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=ColumnPartitionDefinitionItem.class)
public class ColumnPartitionDefinitionItemUnParser
implements UnParser<ColumnPartitionDefinitionItem> {
    @Override
    public void unParse(ColumnPartitionDefinitionItem sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getColId() != null) {
            if (sqlNode.getIndex() != 0) {
                writer.append(",").newLine();
            }
            writer.append(sqlNode.getColId()).writeSpace(1);
        }
        if (sqlNode.getDataType() != null) {
            sqlNode.getDataType().unParse(writer, context);
            writer.writeSpace(1);
        }
        if (sqlNode.getColumnDataTypeAttributes() != null) {
            for (int i = 0; i < sqlNode.getColumnDataTypeAttributes().getNodes().size(); ++i) {
                sqlNode.getColumnDataTypeAttributes().getNodes().get(i).unParse(writer, context);
                if (i == sqlNode.getColumnDataTypeAttributes().getNodes().size() - 1) continue;
                writer.append(", ").newLine();
            }
        }
        if (sqlNode.getTableConstraint() != null) {
            TableConstraint tableConstraint = sqlNode.getTableConstraint();
            if ("UNIQUE".equalsIgnoreCase(tableConstraint.getConstraintType()) && !tableConstraint.getColumnList().containsAll(sqlNode.getPrimaryIndexList())) {
                return;
            }
            if (sqlNode.getIndex() != 0) {
                writer.append(",").newLine();
            }
            writer.append("CONSTRAINT ");
            writer.append(tableConstraint.getConstraintName()).writeSpace();
            writer.append(tableConstraint.getConstraintType()).append(" (");
            if (tableConstraint.getColumnList() != null) {
                int size = tableConstraint.getColumnList().size();
                for (int i = 0; i < size; ++i) {
                    writer.append(tableConstraint.getColumnList().get(i));
                    if (i == size - 1) continue;
                    writer.append(" ,");
                }
            }
            writer.append(")");
        }
    }
}

