/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.ColumnPartitionDefinitionItem;
import com.huawei.hwclouds.migration.td.nodes.CreateTable;
import com.huawei.hwclouds.migration.td.nodes.CtasColumnDefinition;
import com.huawei.hwclouds.migration.td.nodes.IndexItem;
import com.huawei.hwclouds.migration.td.nodes.PrimaryIndexColumn;
import com.huawei.hwclouds.migration.td.nodes.TableConstraint;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateTable.class)
public class CreateTableUnParser
implements UnParser<CreateTable> {
    @Override
    public void unParse(CreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE ");
        if (sqlNode.getTableKind() != null) {
            sqlNode.getTableKind().unParse(writer, context);
        }
        writer.append("TABLE ");
        if (sqlNode.getTableSpecification() != null) {
            sqlNode.getTableSpecification().unParse(writer, context);
        }
        if (sqlNode.getColumnPartitionDefinitionItemSqlNodeList() != null) {
            writer.append("( ");
            int size = sqlNode.getColumnPartitionDefinitionItemSqlNodeList().getNodes().size();
            for (int i = 0; i < size; ++i) {
                ColumnPartitionDefinitionItem columnItem = sqlNode.getColumnPartitionDefinitionItemSqlNodeList().getNodes().get(i);
                columnItem.setIndex(i);
                columnItem.setPrimaryIndexList(sqlNode.getPrimaryIndexList());
                columnItem.unParse(writer, context);
            }
            writer.append(")");
        }
        this.unParsePrimaryIndexList(sqlNode, writer, context);
        if (sqlNode.getCreateTableAsClause() != null) {
            sqlNode.getCreateTableAsClause().unParse(writer, context);
        }
        if (sqlNode.getTablePreservation() != null && sqlNode.getColumnPartitionDefinitionItemSqlNodeList() != null && sqlNode.getCreateTableAsClause() == null) {
            writer.newLine().append("ON COMMIT ").append(sqlNode.getTablePreservation()).append(" ROWS");
        }
        writer.sqlEnd();
        this.unParseIndex(sqlNode, writer, context);
        if (sqlNode.getCtasColumnDefinitionList() != null) {
            for (CtasColumnDefinition ctasColumnDefinition : sqlNode.getCtasColumnDefinitionList()) {
                this.unParseTableConstraint(sqlNode, ctasColumnDefinition.getTableConstraint(), writer, context);
            }
        }
    }

    public void unParsePrimaryIndexList(CreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        List<String> primaryIndexList = sqlNode.getPrimaryIndexList();
        if (primaryIndexList != null && !primaryIndexList.isEmpty()) {
            writer.append("DISTRIBUTE BY HASH (");
            for (int i = 0; i < primaryIndexList.size(); ++i) {
                writer.append(primaryIndexList.get(i));
                if (i == primaryIndexList.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(")");
        }
    }

    private void unParseIndex(CreateTable sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getIndex() == null || sqlNode.getTableSpecification() == null) {
            return;
        }
        List<IndexItem> indexItemList = sqlNode.getIndex().getIndexItemSqlNodeList().getNodes();
        for (IndexItem indexItem : indexItemList) {
            if (indexItem.getPrimary() != null && indexItem.getUnique() == null) continue;
            writer.newLine();
            if (indexItem.getUnique() != null && this.containsAll(indexItem, sqlNode.getPrimaryIndexList())) {
                writer.append("CREATE UNIQUE INDEX ");
            } else {
                writer.append("CREATE INDEX ");
            }
            if (indexItem.getIndexName() != null) {
                writer.append(indexItem.getIndexName()).writeSpace();
            }
            writer.append("ON ").append(sqlNode.getTableSpecification().getTableName()).append(" (");
            if (indexItem.getPrimaryIndexColumnSqlNodeList() != null) {
                indexItem.getPrimaryIndexColumnSqlNodeList().unParse(writer, context);
            }
            writer.append(")").sqlEnd();
        }
    }

    private void unParseTableConstraint(CreateTable createTable, TableConstraint tableConstraint, SqlWriter writer, UnParserContext context) {
        writer.newLine();
        if ("UNIQUE".equals(tableConstraint.getConstraintType()) && createTable.getPrimaryIndexList() != null && !tableConstraint.getColumnList().containsAll(createTable.getPrimaryIndexList())) {
            writer.append("CREATE INDEX ");
            if (tableConstraint.getConstraintName() != null) {
                writer.append(tableConstraint.getConstraintName()).writeSpace();
            }
            writer.append("ON ").append(createTable.getTableSpecification().getTableName());
        } else {
            writer.append("ALTER TABLE ").append(createTable.getTableSpecification().getTableName()).append(" ADD ");
            if (tableConstraint.getConstraintName() != null) {
                writer.append("Constraint ").append(tableConstraint.getConstraintName()).writeSpace();
            }
        }
        writer.append(tableConstraint.getConstraintType()).append(" ( ");
        for (int i = 0; i < tableConstraint.getColumnList().size(); ++i) {
            writer.append(tableConstraint.getColumnList().get(i));
            if (i == tableConstraint.getColumnList().size() - 1) continue;
            writer.append(", ");
        }
        writer.append(")").sqlEnd();
    }

    private boolean containsAll(IndexItem indexItem, List<String> primaryIndexList) {
        if (indexItem.getPrimary() != null || primaryIndexList == null || primaryIndexList.isEmpty()) {
            return true;
        }
        Set indexColIdList = indexItem.getPrimaryIndexColumnSqlNodeList().getNodes().stream().map(PrimaryIndexColumn::getIndexColId).collect(Collectors.toSet());
        return indexColIdList.containsAll(primaryIndexList);
    }
}

