/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.DataType;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=DataType.class)
public class DataTypeUnParser
implements UnParser<DataType> {
    @Override
    public void unParse(DataType sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getTypeName() != null) {
            this.writeAppendDataType(sqlNode, writer, context);
        }
    }

    private void writeAppendDataType(DataType sqlNode, SqlWriter writer, UnParserContext context) {
        switch (sqlNode.getTypeName()) {
            case VARBYTE: 
            case VARGRAPHIC: 
            case GRAPHIC: 
            case BYTE: 
            case LONG_VARGRAPHIC: 
            case BINARY: {
                writer.append(sqlNode.getTypeName().getTarget());
                break;
            }
            default: {
                writer.append(sqlNode.getTypeName().getTarget());
                if (sqlNode.getNumericParameter() != null) {
                    writer.append("(");
                    sqlNode.getNumericParameter().unParse(writer, context);
                    writer.append(")");
                }
                if (!sqlNode.isWithTimeZone()) break;
                writer.append(" WITH TIME ZONE");
            }
        }
    }
}

