/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.SqlNode;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FormatUnParser {
    private static final Pattern LEFT_ZERO_PATTERN = Pattern.compile("'9\\(([0-9]+)\\)'");
    private static final Pattern LEFT_ZERO_PATTERN2 = Pattern.compile("'[0-9]+'");
    private static final Pattern LEFT_SPACE_PATTERN = Pattern.compile("(?i)'z\\(([0-9]+)\\)'");

    public void unParseFormat(String format, SqlNode sqlNode, SqlWriter writer, UnParserContext context, boolean formatDate) {
        Matcher matcher = LEFT_ZERO_PATTERN.matcher(format);
        if (matcher.find()) {
            String leftZero = matcher.group(1);
            writer.append("LPAD(");
            this.unParseExpression(sqlNode, writer, context);
            writer.append(",").append(leftZero).append(",'0')");
            return;
        }
        matcher = LEFT_ZERO_PATTERN2.matcher(format);
        if (matcher.find()) {
            int leftZero = format.length() - 2;
            writer.append("LPAD(");
            this.unParseExpression(sqlNode, writer, context);
            writer.append(",").append(Integer.toString(leftZero)).append(",'0')");
            return;
        }
        matcher = LEFT_SPACE_PATTERN.matcher(format);
        if (matcher.find()) {
            String leftSpace = matcher.group(1);
            writer.append("LPAD(");
            this.unParseExpression(sqlNode, writer, context);
            writer.append(",").append(leftSpace).append(",' ')");
        } else if (formatDate) {
            writer.append("TO_CHAR(");
            this.unParseExpression(sqlNode, writer, context);
            writer.append(",").append(this.convertDateTimeFormat(format)).append(")");
        } else {
            this.unParseExpression(sqlNode, writer, context);
        }
    }

    private String convertDateTimeFormat(String format) {
        format = format.replace("B", " ");
        format = format.replace("S(6)", "US");
        format = format.replace("S(3)", "MS");
        format = format.replace("S(0)", "SS");
        return format;
    }

    protected abstract void unParseExpression(SqlNode var1, SqlWriter var2, UnParserContext var3);
}

