/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.constant.FunctionName;
import com.huawei.hwclouds.migration.td.nodes.ExpressionAtom;
import com.huawei.hwclouds.migration.td.nodes.MathExpressionAtom;
import com.huawei.hwclouds.migration.td.nodes.TypeName;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=MathExpressionAtom.class)
public class MathExpressionAtomUnParser
implements UnParser<MathExpressionAtom> {
    private static final Pattern DATE_PATTERN = Pattern.compile("(?i)date'[\\d-]+'");

    @Override
    public void unParse(MathExpressionAtom sqlNode, SqlWriter writer, UnParserContext context) {
        boolean dateSubtract = false;
        if ("-".equals(sqlNode.getMathOperator()) && (this.isDateExpression(sqlNode.getLeft()) || this.isDateExpression(sqlNode.getRight()))) {
            dateSubtract = true;
        }
        if (dateSubtract) {
            writer.append("EXTRACT('DAY' FROM (");
        }
        sqlNode.getLeft().unParse(writer, context);
        writer.writeSpace();
        if ("**".equals(sqlNode.getMathOperator())) {
            writer.append("^");
        } else if ("MOD".equalsIgnoreCase(sqlNode.getMathOperator())) {
            writer.append("%");
        } else if ("^=".equals(sqlNode.getMathOperator())) {
            writer.append("<>");
        } else if ("EQ".equalsIgnoreCase(sqlNode.getMathOperator())) {
            writer.append("=");
        } else if ("NE".equalsIgnoreCase(sqlNode.getMathOperator())) {
            writer.append("<>");
        } else if ("LE".equalsIgnoreCase(sqlNode.getMathOperator())) {
            writer.append("<=");
        } else if ("GE".equalsIgnoreCase(sqlNode.getMathOperator())) {
            writer.append(">=");
        } else if ("LT".equalsIgnoreCase(sqlNode.getMathOperator())) {
            writer.append("<");
        } else if ("GT".equalsIgnoreCase(sqlNode.getMathOperator())) {
            writer.append(">");
        } else if ("NOT=".equalsIgnoreCase(sqlNode.getMathOperator())) {
            writer.append("<>");
        } else {
            writer.append(sqlNode.getMathOperator());
        }
        writer.writeSpace();
        sqlNode.getRight().unParse(writer, context);
        if (dateSubtract) {
            writer.append("))");
        }
    }

    private boolean isDateExpression(ExpressionAtom expressionAtom) {
        if (expressionAtom.getFunctionCallExpression() != null && (FunctionName.DATE_FUNCTION.contains((Object)expressionAtom.getFunctionCallExpression().getFunctionName()) || expressionAtom.getFunctionCallExpression().getFunctionName() == FunctionName.CAST && expressionAtom.getFunctionCallExpression().getDataType().getTypeName() == TypeName.DATE)) {
            return true;
        }
        if (expressionAtom.getUid() != null) {
            if (expressionAtom.getUid().equalsIgnoreCase("DATE")) {
                return true;
            }
            Matcher matcher = DATE_PATTERN.matcher(expressionAtom.getUid());
            if (matcher.matches()) {
                return true;
            }
            return expressionAtom.getUid().endsWith("Date") || expressionAtom.getUid().toLowerCase(Locale.ROOT).endsWith("_date");
        }
        return false;
    }
}

