/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.nodes.Predicate;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=Predicate.class)
public class PredicateUnParser
implements UnParser<Predicate> {
    @Override
    public void unParse(Predicate sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isBracket()) {
            writer.append("(");
        }
        if (sqlNode.getExpressionAtom() != null) {
            sqlNode.getExpressionAtom().unParse(writer, context);
        } else if (sqlNode.getSubPredicate() != null) {
            sqlNode.getSubPredicate().unParse(writer, context);
            if (sqlNode.isNull()) {
                writer.append(" IS NULL");
            } else if (sqlNode.isNotNull()) {
                writer.append(" IS NOT NULL");
            }
        } else if (sqlNode.getPredicateBefore() != null && sqlNode.getComparisonOperator() != null) {
            String comparisonOperator = sqlNode.getComparisonOperator();
            sqlNode.getPredicateBefore().unParse(writer, context);
            this.unParseComparisonOperator(comparisonOperator, writer);
            if (sqlNode.getPredicateAfter() != null) {
                sqlNode.getPredicateAfter().unParse(writer, context);
            } else if (sqlNode.getPredicateCollection() != null) {
                boolean arrayPredicate;
                boolean bl = arrayPredicate = "LIKE ANY".equalsIgnoreCase(comparisonOperator) || "NOT LIKE ANY".equalsIgnoreCase(comparisonOperator) || "LIKE ALL".equalsIgnoreCase(comparisonOperator) || "NOT LIKE ALL".equalsIgnoreCase(comparisonOperator);
                if (arrayPredicate) {
                    writer.append("(ARRAY[");
                    sqlNode.getPredicateCollection().unParse(writer, context);
                    writer.append("])");
                } else {
                    writer.append("(");
                    sqlNode.getPredicateCollection().unParse(writer, context);
                    writer.append(")");
                }
            }
        }
        if (sqlNode.isBracket()) {
            writer.append(")");
        }
    }

    private void unParseComparisonOperator(String comparisonOperator, SqlWriter writer) {
        writer.writeSpace();
        switch (comparisonOperator.toUpperCase(Locale.ROOT)) {
            case "**": {
                writer.append("^");
                break;
            }
            case "MOD": {
                writer.append("%");
                break;
            }
            case "^=": 
            case "NE": 
            case "NOT=": {
                writer.append("<>");
                break;
            }
            case "EQ": {
                writer.append("=");
                break;
            }
            case "LE": {
                writer.append("<=");
                break;
            }
            case "GE": {
                writer.append(">=");
                break;
            }
            case "LT": {
                writer.append("<");
                break;
            }
            case "GT": {
                writer.append(">");
                break;
            }
            case "IS NOT IN": {
                writer.append("NOT IN");
                break;
            }
            default: {
                writer.append(comparisonOperator);
            }
        }
        writer.writeSpace();
    }
}

