/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.td.UnParser;
import com.huawei.hwclouds.migration.td.UnParserAnnotation;
import com.huawei.hwclouds.migration.td.UnParserContext;
import com.huawei.hwclouds.migration.td.constant.FunctionName;
import com.huawei.hwclouds.migration.td.nodes.Condition;
import com.huawei.hwclouds.migration.td.nodes.Expression;
import com.huawei.hwclouds.migration.td.nodes.ExpressionAtom;
import com.huawei.hwclouds.migration.td.nodes.FunctionCallExpression;
import com.huawei.hwclouds.migration.td.nodes.GroupByClause;
import com.huawei.hwclouds.migration.td.nodes.GroupingSpecification;
import com.huawei.hwclouds.migration.td.nodes.OrdinaryGroupingSet;
import com.huawei.hwclouds.migration.td.nodes.Predicate;
import com.huawei.hwclouds.migration.td.nodes.QualifyClause;
import com.huawei.hwclouds.migration.td.nodes.QueryTerm;
import com.huawei.hwclouds.migration.td.nodes.SelectList;
import com.huawei.hwclouds.migration.td.nodes.SelectedColumn;
import com.huawei.hwclouds.migration.td.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.td.nodes.TypeName;
import com.huawei.hwclouds.migration.td.nodes.WindowSpec;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=QueryTerm.class)
public class QueryTermUnParser
implements UnParser<QueryTerm> {
    @Override
    public void unParse(QueryTerm sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isAsJson() && sqlNode.getQualifyClause() != null) {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Not support using AS JSON and Qualify simultaneously.");
        }
        if (sqlNode.isAsJson()) {
            writer.append("SELECT to_json(t.*) FROM (").newLine();
        } else if (sqlNode.getQualifyClause() != null) {
            writer.append("SELECT t.* FROM (").newLine();
        }
        writer.append("SELECT").writeSpace();
        this.convertCastDateInSelectTarget(sqlNode.getSelectList());
        this.convertWindowFunction(sqlNode);
        sqlNode.getSelectList().unParse(writer, context);
        if (sqlNode.getQualifyClause() != null) {
            this.unParseQualifyClauseSelect(sqlNode.getQualifyClause(), writer, context);
        }
        if (sqlNode.getFromClause() != null) {
            writer.newLine();
            sqlNode.getFromClause().unParse(writer, context);
        }
        if (sqlNode.getWhereClause() != null) {
            writer.newLine().append("WHERE ");
            sqlNode.getWhereClause().unParse(writer, context);
        }
        if (sqlNode.getGroupByClause() != null && sqlNode.getGroupByClause().getGroupSpecificationList() != null && !sqlNode.getGroupByClause().getGroupSpecificationList().isEmpty()) {
            writer.newLine();
            sqlNode.getGroupByClause().unParse(writer, context);
        }
        if (sqlNode.getOrderClause() != null) {
            writer.newLine();
            sqlNode.getOrderClause().unParse(writer, context);
        } else if (sqlNode.getSampleClause() != null) {
            writer.newLine();
            sqlNode.getSampleClause().unParse(writer, context);
        }
        if (sqlNode.getHavingClause() != null) {
            writer.newLine();
            sqlNode.getHavingClause().unParse(writer, context);
        }
        if (sqlNode.isAsJson()) {
            writer.newLine().append(") t");
        } else if (sqlNode.getQualifyClause() != null) {
            writer.newLine().append(") t");
            this.unParseQualifyClauseWhere(sqlNode.getQualifyClause(), writer, context);
        }
    }

    private void convertCastDateInSelectTarget(SelectList selectList) {
        if (selectList == null || selectList.getSelectedColumnList() == null) {
            return;
        }
        selectList.getSelectedColumnList().getNodes().forEach(selectedColumn -> {
            Expression expression = selectedColumn.getExpression();
            if (expression == null || expression.getPredicate() == null || expression.getPredicate().getExpressionAtom() == null || expression.getPredicate().getExpressionAtom().getFunctionCallExpression() == null) {
                return;
            }
            if (expression.getPredicate().getExpressionAtom().getFunctionCallExpression().getFunctionName() == FunctionName.CAST && expression.getPredicate().getExpressionAtom().getFunctionCallExpression().getDataType().getTypeName() == TypeName.DATE && expression.getPredicate().getExpressionAtom().getFunctionCallExpression().getFormat() != null) {
                expression.getPredicate().getExpressionAtom().getFunctionCallExpression().setFormatDate(true);
            }
        });
    }

    private void convertWindowFunction(QueryTerm sqlNode) {
        SelectList selectList = sqlNode.getSelectList();
        if (selectList == null || selectList.getSelectedColumnList() == null) {
            return;
        }
        boolean hasWindowFunction = false;
        for (SelectedColumn selectedColumn : selectList.getSelectedColumnList().getNodes()) {
            hasWindowFunction = this.convertWindowFunctionExpression(sqlNode, selectedColumn.getExpression()) || hasWindowFunction;
        }
        if (sqlNode.getQualifyClause() != null) {
            boolean bl = hasWindowFunction = this.convertWindowFunctionCondition(sqlNode, sqlNode.getQualifyClause().getCondition()) || hasWindowFunction;
        }
        if (hasWindowFunction) {
            sqlNode.setGroupByClause(null);
        }
    }

    private boolean convertWindowFunctionExpression(QueryTerm sqlNode, Expression expression) {
        if (expression == null) {
            return false;
        }
        if (expression.getExpressionBefore() != null) {
            boolean hasWindowFunction = this.convertWindowFunctionExpression(sqlNode, expression.getExpressionBefore());
            return this.convertWindowFunctionExpression(sqlNode, expression.getExpressionAfter()) || hasWindowFunction;
        }
        Predicate predicate = expression.getPredicate();
        if (predicate.getPredicateBefore() != null) {
            return this.convertWindowFunctionPredicate(sqlNode, predicate.getPredicateBefore());
        }
        return this.convertWindowFunctionPredicate(sqlNode, predicate);
    }

    private boolean convertWindowFunctionCondition(QueryTerm sqlNode, Condition condition) {
        if (condition.getPreCondition() != null) {
            boolean hasWindowFunction = this.convertWindowFunctionCondition(sqlNode, condition.getPreCondition());
            return this.convertWindowFunctionCondition(sqlNode, condition.getPostCondition()) || hasWindowFunction;
        }
        if (condition.getPredicate().getPredicateBefore() != null) {
            return this.convertWindowFunctionPredicate(sqlNode, condition.getPredicate().getPredicateBefore());
        }
        return this.convertWindowFunctionPredicate(sqlNode, condition.getPredicate());
    }

    private boolean convertWindowFunctionPredicate(QueryTerm sqlNode, Predicate predicate) {
        boolean hasWindowFunction = false;
        if (predicate.getExpressionAtom() == null || predicate.getExpressionAtom().getFunctionCallExpression() == null) {
            return hasWindowFunction;
        }
        FunctionCallExpression functionCallExpression = predicate.getExpressionAtom().getFunctionCallExpression();
        if (functionCallExpression.getArgList() != null) {
            for (Expression node : functionCallExpression.getArgList().getNodes()) {
                hasWindowFunction = this.convertWindowFunctionExpression(sqlNode, node) || hasWindowFunction;
            }
        }
        WindowSpec windowSpec = null;
        SqlNodeList<Object> ordinaryGroupingSetSqlNodeList = new SqlNodeList();
        if (functionCallExpression.getOrderArgList() != null) {
            windowSpec = new WindowSpec();
            windowSpec.setOrderBySpecificationList(functionCallExpression.getOrderArgList());
            functionCallExpression.setWindowSpec(windowSpec);
            ordinaryGroupingSetSqlNodeList = this.parseGroupToPartition(sqlNode.getGroupByClause());
        } else if (functionCallExpression.getWindowSpec() != null && functionCallExpression.getWindowSpec().getWindowPartitionByList() == null) {
            windowSpec = functionCallExpression.getWindowSpec();
            ordinaryGroupingSetSqlNodeList = this.parseGroupToPartition(sqlNode.getGroupByClause());
        } else {
            return hasWindowFunction;
        }
        if (!ordinaryGroupingSetSqlNodeList.isEmpty()) {
            windowSpec.setOrdinaryGroupingSetList(ordinaryGroupingSetSqlNodeList);
            hasWindowFunction = true;
        }
        return hasWindowFunction;
    }

    private SqlNodeList<OrdinaryGroupingSet> parseGroupToPartition(GroupByClause groupByClause) {
        SqlNodeList<OrdinaryGroupingSet> partitionList = new SqlNodeList<OrdinaryGroupingSet>();
        if (groupByClause == null || groupByClause.getGroupSpecificationList() == null) {
            return partitionList;
        }
        for (GroupingSpecification groupingSpecification : groupByClause.getGroupSpecificationList().getNodes()) {
            if (groupingSpecification.isCube()) {
                throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Syntax [group by cube()] is not not supported when no partition window function is used");
            }
            if (groupingSpecification.isRollup()) {
                throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Syntax [group by rollup()] is not not supported when no partition window function is used");
            }
            if (groupingSpecification.isEmptyGroupingSet()) continue;
            if (groupingSpecification.getGroupSetSpecification() != null) {
                throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Syntax [group by grouping sets()] is not not supported when no partition window function is used");
            }
            partitionList.addNode(groupingSpecification.getOrdinaryGroupingSet());
        }
        return partitionList;
    }

    private void unParseQualifyClauseSelect(QualifyClause sqlNode, SqlWriter writer, UnParserContext context) {
        int conditionCount = 1;
        Condition condition = sqlNode.getCondition();
        this.recursiveQualifyCondition(condition, conditionCount, writer, context);
    }

    private int recursiveQualifyCondition(Condition condition, int conditionCount, SqlWriter writer, UnParserContext context) {
        if (condition.getPredicate() != null) {
            Predicate predicate = condition.getPredicate().getPredicateBefore() != null ? condition.getPredicate().getPredicateBefore() : (condition.getPredicate().getSubPredicate() != null ? condition.getPredicate().getSubPredicate() : condition.getPredicate());
            if (predicate.getExpressionAtom().getUid() != null) {
                return conditionCount;
            }
            writer.append(",");
            String alias = "qualifyAlias" + conditionCount;
            predicate.getExpressionAtom().unParse(writer, context);
            writer.append(" AS " + alias);
            ++conditionCount;
            ExpressionAtom expressionAtom = new ExpressionAtom();
            expressionAtom.setUid(alias);
            Predicate aliasPredicate = new Predicate();
            aliasPredicate.setExpressionAtom(expressionAtom);
            if (condition.getPredicate().getPredicateAfter() != null || condition.getPredicate().getPredicateCollection() != null) {
                condition.getPredicate().setPredicateBefore(aliasPredicate);
            } else {
                condition.getPredicate().setSubPredicate(aliasPredicate);
            }
        } else {
            conditionCount = this.recursiveQualifyCondition(condition.getPreCondition(), conditionCount, writer, context);
            conditionCount = this.recursiveQualifyCondition(condition.getPostCondition(), conditionCount, writer, context);
        }
        return conditionCount;
    }

    private void unParseQualifyClauseWhere(QualifyClause sqlNode, SqlWriter writer, UnParserContext context) {
        writer.newLine().append("WHERE ");
        sqlNode.getCondition().unParse(writer, context);
    }
}

