/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.td.writer;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.td.util.SqlDialect;
import com.huawei.hwclouds.migration.td.util.SqlString;
import com.huawei.hwclouds.migration.td.writer.SqlWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqlPrettyWriter
implements SqlWriter {
    private static final Logger LOGGER = LogManager.getLogger(SqlPrettyWriter.class);
    private static final int INDENTATION_SPACE_SIZE = 2;
    private SqlDialect dialect;
    private int indentationLevel = 0;
    private StringWriter sw = new StringWriter();
    private ConvertConfig defaultConfig;
    private Map<String, ConvertConfig> tableConfigs;

    public SqlPrettyWriter(SqlDialect dialect, ConvertConfig defaultConfig, Map<String, ConvertConfig> tableConfigs) {
        this.dialect = dialect;
        this.defaultConfig = defaultConfig;
        this.tableConfigs = tableConfigs;
    }

    @Override
    public SqlWriter append(String sql) {
        if (sql == null || sql.isEmpty()) {
            return this;
        }
        this.sw.append(sql);
        return this;
    }

    @Override
    public SqlWriter append(SqlWriter writer) {
        this.sw.append(writer.toSqlString().getSql());
        return this;
    }

    @Override
    public SqlWriter writeSpace() {
        this.sw.append(" ");
        return this;
    }

    @Override
    public SqlWriter writeSpace(int size) {
        for (int i = 0; i < size; ++i) {
            this.sw.append(" ");
        }
        return this;
    }

    @Override
    public SqlWriter indentation(int level) {
        for (int i = 0; i < level; ++i) {
            this.writeSpace(2);
        }
        return this;
    }

    @Override
    public SqlWriter newLine() {
        this.sw.append(System.lineSeparator());
        return this;
    }

    @Override
    public SqlWriter sqlEnd() {
        this.sw.append(";");
        return this;
    }

    @Override
    public SqlString toSqlString() {
        return new SqlString(this.dialect, this.sw.toString());
    }

    @Override
    public SqlDialect getDialect() {
        return this.dialect;
    }
}

