/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import java.util.HashMap;
import java.util.Map;

public class DWSConfig
extends ConvertConfig {
    public static final String DWS_CONVERTOR_PROPERTIES = "features-pg.properties";
    public static final String PARAM_CONFIG_FLAG = "param.config.flag";
    public static final String TABLE_ORIENTATION = "table.orientation";
    public static final String TABLE_TYPE = "table.type";
    public static final String TABLE_COMPRESS_LEVEL = "table.compress.level";
    public static final String TABLE_COLVERSION_VERSION = "table.colversion.version";
    public static final String TABLE_ENALBE_DELTA = "table.enable.delta";
    public static final String TABLE_ORIGIN_DATABASE_TYPE = "table.origin.database.type";
    public static final String TABLE_OUTPUT_PLACEHOLDER_FORMAT = "table.output.placeholder.format";
    public static final String TABLE_OUTPUT_FOREIGN_SERVER = "table.output.foreign.server";
    public static final String TABLE_OUTPUT_FOREIGN_OBS_SERVER = "table.output.foreign.obs.server";
    public static final String TABLE_OUTPUT_VARCHAR_COEFFICIENT = "table.output.varchar.coefficient";

    public static DWSConfig buildConfig() {
        return DWSConfig.buildConfig(DWS_CONVERTOR_PROPERTIES);
    }

    public static DWSConfig buildConfig(String configFile) {
        ConvertConfig defaults = ConvertConfig.buildConfig();
        ConvertConfig config = DWSConfig.loadConfig(configFile);
        DWSConfig dwsConfig = new DWSConfig();
        dwsConfig.merge(defaults);
        dwsConfig.merge(config);
        return dwsConfig;
    }

    public static Map<String, DWSConfig> loadTableConfigs() {
        HashMap<String, DWSConfig> tableConfigs = new HashMap<String, DWSConfig>();
        Map<String, ConvertConfig> cfs = DWSConfig.loadTableConfigs(DWS_CONVERTOR_PROPERTIES);
        cfs.entrySet().stream().forEach(et -> {
            DWSConfig dwsConfig = new DWSConfig();
            dwsConfig.merge((ConvertConfig)et.getValue());
            tableConfigs.put((String)et.getKey(), dwsConfig);
        });
        return tableConfigs;
    }
}

