/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.github.vertical_blank.sqlformatter.languages.Dialect;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.hwclouds.migration.common.config.ApplicationPropertyLoader;
import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.entity.PlaceHolderParam;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.common.util.ConvertRuntimeException;
import com.huawei.hwclouds.migration.common.util.MigrationContextUtil;
import com.huawei.hwclouds.migration.pg.DWSMain;
import com.huawei.hwclouds.migration.pg.PgConvertor;
import com.huawei.hwclouds.migration.pg.util.SqlString;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSMigration
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(DWSMigration.class);
    private static int fileNumber = 0;
    private final File inputFile;
    private final String outputFile;
    private PgConvertor convertor;
    private final int range;
    private final int countValidFiles;
    private static final Pattern PROC_FINDER = Pattern.compile("(?i)^(CREATE)[\\s+](OR\\s+REPLACE\\s+)?(FUNCTION|LIBRARY|PACKAGE|PROCEDURE)(\\s+)([\\s\\S]*?)");
    private static final Pattern BEGIN_FINDER = Pattern.compile("(?i)^(BEGIN)(;?)(\\s+)([\\s\\S]*?)");
    private static final Pattern ALTER_TABLE_CONSTRAINT = Pattern.compile("(?i)^(ALTER)(\\s+)(TABLE)[\\S+\\s+]*(ADD)(\\s+)(Constraint)(\\s+)([\\s\\S]*?)");
    private static final Pattern PLACE_HOLDER = Pattern.compile("\\s\\S+\\$\\{\\S+([\\s;])");
    private static final String PLACE_HOLDER_IN_COMMENT = "!PLACE_HOLDER_IN_COMMENT!{";

    DWSMigration(File inFile, String outFile, int rangNum, int countValidFilesNum) {
        this.inputFile = inFile;
        this.outputFile = outFile;
        this.range = rangNum;
        this.countValidFiles = countValidFilesNum;
        this.convertor = new PgConvertor(null);
    }

    @Override
    public void run() {
        LOGGER.info("start migrate file : {}", (Object)this.inputFile.getName());
        try {
            String resSql = DWSMigration.parseFile(this.inputFile, this.convertor, this.range);
            if (resSql == null) {
                DWSMain.FAILED_FILES.incrementAndGet();
                return;
            }
            boolean fileCreate = CommonUtils.createNewFile(this.outputFile, false);
            if (!fileCreate) {
                LOGGER.error("Error while creating file");
                return;
            }
            String encodingFormat = DWSMigration.getEncodingFormat();
            FileUtils.write((File)new File(this.outputFile), (CharSequence)resSql, (String)encodingFormat);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse " + this.inputFile.getName(), (Throwable)e);
            try {
                FileUtils.copyFile((File)this.inputFile, (File)new File(this.outputFile));
            }
            catch (IOException pe) {
                LOGGER.error("Faild to copy file " + this.inputFile.getName());
            }
            DWSMain.FAILED_FILES.incrementAndGet();
        }
        int percent = 100;
        DWSMigration.incrementFileCounter();
        int status = this.countValidFiles > 0 ? fileNumber * 100 / this.countValidFiles : 0;
        DWSMain.printConsoleMessage(status + "% completed");
    }

    private static void incrementFileCounter() {
        ++fileNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String parseFile(File inputFile, PgConvertor convertor, int rangeNum) throws IOException {
        String encodingFormat = DWSMigration.getEncodingFormat();
        LineIterator it = FileUtils.lineIterator((File)inputFile, (String)encodingFormat);
        PlaceHolderParam placeHolderParam = new PlaceHolderParam(DWSMigration.getStringValue(convertor.getConfigs(), "param.config.flag", "table.output.placeholder.format"));
        MigrationContextUtil.setPlaceHolderParam(placeHolderParam);
        try {
            StringBuilder resSql = DWSMigration.convertFile(inputFile.getName(), convertor, rangeNum, it);
            String string = resSql.toString();
            return string;
        }
        finally {
            MigrationContextUtil.removeContext();
            LineIterator.closeQuietly((LineIterator)it);
        }
    }

    public static StringBuilder convertFile(String inputFileName, PgConvertor convertor, Integer rangeNum, LineIterator it) {
        StringBuilder resSql = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        StringBuilder storage = new StringBuilder();
        String storageLine = "";
        String firstLine = "";
        while (it.hasNext() || DWSMigration.existStorage(storage, storageLine)) {
            String line;
            if (DWSMigration.existStorage(storage, storageLine)) {
                line = storageLine;
                sb.append((CharSequence)storage);
                storageLine = "";
                storage.delete(0, storage.length());
            } else {
                line = it.nextLine();
            }
            if (firstLine.isEmpty() && line != null && DWSMigration.isShell(line)) {
                resSql.append((CharSequence)sb);
                sb.delete(0, sb.length());
                resSql.append(line);
                resSql.append(System.lineSeparator());
                continue;
            }
            if (line != null && SqlString.isSqlComment(line)) {
                line = DWSMigration.handleCommentLine(line);
                sb.append(line);
                sb.append(System.lineSeparator());
                if (!line.trim().startsWith("/*")) continue;
                while (!line.trim().startsWith("*/") && !line.trim().endsWith("*/") && it.hasNext()) {
                    line = it.nextLine();
                    sb.append(line).append('\n');
                }
                continue;
            }
            if (line != null && firstLine.isEmpty()) {
                firstLine = line;
            }
            line = DWSMigration.handleLine(line, sb);
            if ((line = DWSMigration.readPlSql(sb, it, line)) != null && (line.trim().endsWith(";") || DWSMigration.plsqlEnd(line, sb))) {
                int length = line.trim().length();
                if (length == 1) {
                    String lastInput = sb.toString().trim();
                    sb.delete(0, sb.length());
                    sb.append(lastInput);
                }
                sb.append(line);
                if (firstLine.trim().toUpperCase().startsWith("CREATE TABLE")) {
                    storageLine = DWSMigration.readAlterTable(sb, storage, it);
                }
                int inputLen = sb.length();
                if (rangeNum != null && (inputLen > rangeNum || inputLen <= 1)) {
                    LOGGER.error("validLength:{},inputLen;{}.sql:{}", (Object)rangeNum, (Object)inputLen, (Object)sb.toString());
                    LOGGER.error("Migration of the following file exceeds the max Sql Length: {}", (Object)inputFileName);
                    return null;
                }
                DWSMigration.convert(inputFileName, convertor, sb, resSql);
                sb.delete(0, sb.length());
                firstLine = "";
                continue;
            }
            sb.append(line);
            if ((line == null || line.isEmpty()) && sb.toString().trim().isEmpty()) {
                resSql.append(System.lineSeparator());
                continue;
            }
            sb.append(System.lineSeparator());
        }
        DWSMigration.convert(inputFileName, convertor, sb, resSql);
        return resSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String inputFileName, PgConvertor convertor, StringBuilder sb, StringBuilder resSql) {
        String altString = sb.toString().toUpperCase(Locale.ROOT);
        if (altString.contains("SET @@") || altString.contains("SET @")) {
            StringBuilder sql = new StringBuilder();
            LOGGER.warn("Sql syntax not supported:PLSQL SET @@/@, FileName:" + inputFileName + ", OriSql:" + sb.toString());
            DWSMain.FAILED_SQL.incrementAndGet();
            resSql.append((CharSequence)sql.append("/* sql not support\r\n").append((CharSequence)sb).append("*/;"));
            return;
        }
        try {
            convertor.reset();
            convertor.parse(sb.toString());
            String sql = convertor.convert().getSql();
            sql = DWSMigration.handlePlaceHolderParam(sql);
            SqlFormatter.Formatter of = SqlFormatter.of((Dialect)Dialect.PostgreSql);
            String format = SqlString.handleErrorRes(of.format(sql, MigrationContextUtil.getPlaceHolderMap()));
            format = format.replace(" E '", " E'");
            format = format.replace("| |", "||");
            resSql.append(format);
        }
        catch (Exception e) {
            DWSMigration.handleException(e, resSql, inputFileName, sb);
        }
        finally {
            MigrationContextUtil.clearPlaceholderParam();
            Integer count = convertor.getCount() + 1;
            Long time = new Date().getTime();
            Long elapsed = time - convertor.getLastTime();
            String logLine = DWSMigration.getShortLine(sb);
            LOGGER.info("inputFile name :{} , migrated count: {},elapsed this time: {} ms ,first line : {}", (Object)inputFileName, (Object)count, (Object)elapsed, (Object)logLine);
            convertor.setCount(count);
            convertor.setLastTime(time);
        }
        resSql.append(System.lineSeparator());
    }

    private static String getShortLine(StringBuilder sb) {
        String logLine = sb.length() > 50 ? sb.substring(0, 50) : sb.toString();
        int newlineIndex = logLine.indexOf("\r\n");
        if (newlineIndex > -1) {
            logLine = logLine.substring(0, newlineIndex);
        }
        return logLine;
    }

    private static String handlePlaceHolderParam(String sql) {
        Map<String, String> placeHolderMap = MigrationContextUtil.getPlaceHolderMap();
        Matcher matcher = PLACE_HOLDER.matcher(sql);
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            result.append(sql, lastEnd, matcher.start());
            String text = matcher.group();
            if (matcher.start() > 0 && sql.charAt(matcher.start() - 1) == '\'' || text.contains("'")) {
                result.append(text);
            } else {
                int index = placeHolderMap.size();
                result.append(" :").append(index).append(text.substring(text.length() - 1));
                placeHolderMap.put(String.valueOf(index), text.substring(0, text.length() - 1));
            }
            lastEnd = matcher.end();
        }
        result.append(sql.substring(lastEnd));
        return result.toString().replace(PLACE_HOLDER_IN_COMMENT, "${");
    }

    private static void handleException(Exception e, StringBuilder resSql, String inputFile, StringBuilder sb) {
        DWSMain.FAILED_SQL.incrementAndGet();
        if (e instanceof ParserRuntimeException) {
            ParserRuntimeException exception = (ParserRuntimeException)e;
            LOGGER.error("Sql syntax not supported,exceptionCode:[{}],exceptionMessage:[{}],FileName:{}.", (Object)exception.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql syntax not supported, errorCode: ").append(exception.getExceptionCode()).append(", errorMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("*/;");
        } else if (e instanceof ParserException || e instanceof ConvertRuntimeException) {
            LOGGER.warn("Sql parser failed, exceptionCode:[{}],exceptionMessage:[{}],FileName:[{}]", (Object)ParserExceptionDef.SQL_PARSER_EXCEPTION.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql parser failed, errorCode: ").append(ParserExceptionDef.SQL_PARSER_EXCEPTION.getExceptionCode()).append(", errorMessage: ").append(e.getMessage()).append("\r\n").append((CharSequence)sb).append("*/;");
        } else {
            LOGGER.warn("Sql convert failed, exceptionCode:[{}],exceptionMessage:[{}],FileName:[{}]", (Object)ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionCode(), (Object)e.getMessage(), (Object)inputFile);
            resSql.append("/* Sql parser failed, errorCode: ").append(ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionCode()).append(", errorMessage: ").append(ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionMessage(new Object[0])).append("\r\n").append((CharSequence)sb).append("*/;");
        }
    }

    public static boolean isShell(String line) {
        String lowerCase = line.trim().toLowerCase(Locale.ROOT);
        return lowerCase.startsWith("psql ") || lowerCase.startsWith("hadoop ") || lowerCase.startsWith("\\\\") || lowerCase.startsWith("refresh ") || lowerCase.startsWith("msck repair ") || lowerCase.startsWith("${");
    }

    public static String handleLine(String line, StringBuilder sb) {
        if (line == null || line.isEmpty()) {
            return line;
        }
        String sbTrim = sb.toString().trim();
        String lineTrim = line.trim();
        if (sbTrim.endsWith("'") && lineTrim.startsWith("'")) {
            line = "||" + line;
        }
        if (lineTrim.endsWith(";;")) {
            line = line.replaceAll(";;", ";");
        }
        line = line.replaceAll("\\\\\"", "\"");
        return line;
    }

    public static String handleCommentLine(String line) {
        String lineTrim = line.trim();
        if (lineTrim.startsWith("/*") && lineTrim.endsWith("*/") && !lineTrim.contains(" ")) {
            line = line.replace("/*", "/* ");
        }
        if (line.trim().startsWith("#")) {
            line = line.replaceFirst("#", "--");
        }
        line = line.replaceAll("\\$\\{", PLACE_HOLDER_IN_COMMENT);
        return line;
    }

    private static String readPlSql(StringBuilder sb, LineIterator it, String line) {
        Matcher beginMatcher;
        String[] s = sb.toString().split("\r?\n");
        StringBuilder plsql = new StringBuilder();
        for (String value : s) {
            if (SqlString.isSqlComment(value)) continue;
            plsql.append(value);
        }
        plsql.append(line);
        plsql.append(line).append(System.lineSeparator());
        String plsqlStr = plsql.toString().toUpperCase(Locale.ROOT);
        boolean languageC = plsqlStr.contains("LANGUAGE C");
        Matcher plsqlMatcher = PROC_FINDER.matcher(plsql);
        if ((plsqlMatcher.matches() || plsqlStr.startsWith("DO ")) && it.hasNext()) {
            sb.append(line).append('\n');
            line = it.nextLine();
            boolean bl = languageC = languageC || line.toUpperCase(Locale.ROOT).contains("LANGUAGE C");
            while (!DWSMigration.functionEnd(sb, line, languageC) || line.endsWith("*/")) {
                if (line.toUpperCase(Locale.ROOT).trim().startsWith("FOR")) {
                    line = line.replace("..", " .. ");
                }
                line = DWSMigration.handleCommentLine(line);
                sb.append(line).append('\n');
                if (!it.hasNext()) break;
                line = it.nextLine();
            }
        }
        if ((beginMatcher = BEGIN_FINDER.matcher(plsql)).matches() && !plsql.toString().replace(" ", "").equalsIgnoreCase("begintransaction;")) {
            sb.append(line).append('\n');
            if (it.hasNext()) {
                line = it.nextLine();
                while (!line.trim().equalsIgnoreCase("END;")) {
                    line = DWSMigration.handleCommentLine(line);
                    sb.append(line).append('\n');
                    if (!it.hasNext()) break;
                    line = it.nextLine();
                }
            }
        }
        return line;
    }

    private static String readAlterTable(StringBuilder sb, StringBuilder storage, LineIterator it) {
        String line = null;
        while (it.hasNext()) {
            line = it.nextLine();
            if (line == null || line.isEmpty()) continue;
            if (SqlString.isSqlComment(line)) {
                line = DWSMigration.handleCommentLine(line);
                storage.append(line);
                storage.append(System.lineSeparator());
                if (!line.trim().startsWith("/*")) continue;
                while (!line.trim().startsWith("*/") && !line.trim().endsWith("*/") && it.hasNext()) {
                    line = it.nextLine();
                    storage.append(line).append('\n');
                }
                continue;
            }
            Matcher plsqlMatcher = ALTER_TABLE_CONSTRAINT.matcher(line);
            if (!plsqlMatcher.matches()) {
                return line;
            }
            if (line.trim().endsWith(";")) {
                sb.append((CharSequence)storage).append(line);
                storage.delete(0, storage.length());
                return "";
            }
            storage.append(line).append(System.lineSeparator());
        }
        return line;
    }

    private static boolean functionEnd(StringBuilder sb, String line, boolean languageC) {
        if (languageC) {
            return line.trim().endsWith(";");
        }
        return DWSMigration.plsqlEnd(line, sb);
    }

    private static boolean plsqlEnd(String line, StringBuilder sb) {
        String lineTrim = line.trim();
        return sb.toString().trim().endsWith(";") && lineTrim.endsWith("/") && !lineTrim.endsWith("*/") || lineTrim.endsWith("END_PROC;") || lineTrim.endsWith("$$;") || lineTrim.endsWith("$_$;") || (lineTrim.contains("LANGUAGE c") || lineTrim.contains("LANGUAGE sql") || lineTrim.contains("LANGUAGE plpgsql")) && lineTrim.endsWith(";");
    }

    private static String getEncodingFormat() {
        String encodingFormat = null;
        encodingFormat = ApplicationPropertyLoader.getStringProperty("encodingFormat");
        if (encodingFormat.equals("")) {
            encodingFormat = "UTF8";
            LOGGER.info("Files encoding is set to default UTF8");
        }
        LOGGER.info("Files encoding is set from configuration in Application properties file : {}", (Object)encodingFormat);
        return encodingFormat;
    }

    private static boolean existStorage(StringBuilder storage, String storageLine) {
        return storage.length() > 0 || storageLine != null && !storageLine.isEmpty();
    }

    public static String getStringValue(Map<String, ConvertConfig> configs, String configKey, String paramKey) {
        ConvertConfig dwsConfig = configs.get(configKey);
        if (dwsConfig != null) {
            return dwsConfig.getStringValue(paramKey);
        }
        return null;
    }
}

