/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg;

import com.huawei.hwclouds.migration.common.constant.CommentPosition;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.SqlCommentNode;
import com.huawei.hwclouds.migration.pg.nodes.SqlNode;
import com.huawei.hwclouds.migration.pg.nodes.SqlRoot;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

public interface UnParser<T extends SqlNode> {
    public void unParse(T var1, SqlWriter var2, UnParserContext var3);

    default public void unParseWithComment(T sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode instanceof SqlRoot) {
            this.unParse(sqlNode, writer, context);
            this.unParseComment((SqlRoot)sqlNode, writer);
        } else if (sqlNode instanceof SqlCommentNode) {
            SqlCommentNode sqlCommentNode = (SqlCommentNode)sqlNode;
            if (sqlCommentNode.getCommentPosition() == null || sqlCommentNode.getCommentPosition() == CommentPosition.PRE) {
                this.unParseComment((SqlCommentNode)sqlNode, writer);
            }
            this.unParse(sqlNode, writer, context);
            if (sqlCommentNode.getCommentPosition() == CommentPosition.POST) {
                this.unParseComment((SqlCommentNode)sqlNode, writer);
            }
        } else {
            this.unParse(sqlNode, writer, context);
        }
    }

    default public void unParseComment(SqlCommentNode comments, SqlWriter writer) {
        if (comments.getComments() == null || comments.getComments().isEmpty()) {
            return;
        }
        comments.getComments().stream().map(stream -> {
            if (stream.trim().startsWith("#")) {
                StringBuilder sb = new StringBuilder("--");
                int hashtagStart = 0;
                int hashtagEnd = 0;
                char[] cs = stream.toCharArray();
                for (int index = 0; index < cs.length; ++index) {
                    if (cs[index] == '#') {
                        if (hashtagStart == 0) {
                            hashtagStart = index;
                        }
                        if (hashtagStart == 0 || hashtagEnd == 0) continue;
                        sb.append(cs[index]);
                        continue;
                    }
                    if (hashtagStart != 0 && hashtagEnd == 0) {
                        hashtagEnd = index;
                    }
                    sb.append(cs[index]);
                }
                return sb.toString();
            }
            return stream;
        }).forEach(s -> writer.append((String)s).writeSpace());
    }
}

