/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg;

import com.huawei.hwclouds.migration.common.util.ClassScanner;
import com.huawei.hwclouds.migration.common.util.ConvertRuntimeException;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.nodes.SqlNode;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UnParserFactory {
    private static final Logger LOGGER = LogManager.getLogger(UnParserFactory.class);
    private static final Map<SqlDialect, Map<Class<? extends SqlNode>, Class<? extends UnParser>>> UNPARSERS = new HashMap<SqlDialect, Map<Class<? extends SqlNode>, Class<? extends UnParser>>>();
    private static final String UNPARSER_ANNOATION_SCAN_DWS = "com.huawei.hwclouds.migration.pg.unparser";

    public static UnParser getUnParser(Class<? extends SqlNode> c, SqlDialect dialect) {
        LOGGER.debug("get unParser from sqlNode :{}, dialect: {}", (Object)c.getSimpleName(), (Object)dialect);
        Map<Class<? extends SqlNode>, Class<? extends UnParser>> dialectMap = UNPARSERS.get((Object)dialect);
        if (dialectMap == null) {
            LOGGER.error("Can not found unParser for dialect : {}", (Object)dialect);
            throw new ConvertRuntimeException("Can not found unParser for dialect : " + (Object)((Object)dialect));
        }
        try {
            Class<? extends UnParser> unParser = dialectMap.get(c);
            if (unParser == null) {
                LOGGER.error("Can not found unParser class from sqlNode : " + c.getSimpleName());
                throw new ConvertRuntimeException("Can not found unParser class from sqlNode : " + c.getSimpleName());
            }
            return unParser.newInstance();
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Can not found unParser class from sqlNode : " + c.getSimpleName());
            throw new ConvertRuntimeException("Can not found unParser class from sqlNode : " + c.getSimpleName(), e);
        }
    }

    static {
        new ClassScanner(classHandler -> {
            UnParserAnnotation annotation = classHandler.getAnnotation(UnParserAnnotation.class);
            if (annotation == null) {
                return;
            }
            if (!UNPARSERS.containsKey((Object)annotation.dialect())) {
                UNPARSERS.put(annotation.dialect(), new HashMap());
            }
            LOGGER.debug("Add class {}, for dialect {}, sqlNode {}.", (Object[])new String[]{classHandler.getSimpleName(), annotation.dialect().toString(), annotation.sqlNode().getSimpleName()});
            UNPARSERS.get((Object)annotation.dialect()).put(annotation.sqlNode(), classHandler);
        }).scan(UNPARSER_ANNOATION_SCAN_DWS);
    }
}

