/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.Objects;

public class WriterUtil {
    public static void writerComma(int commaCnt, SqlWriter writer, int count) {
        if (commaCnt > 1 || commaCnt == 1 && count != 0) {
            writer.append(", ");
        }
    }

    public static void writerNoOptionComma(int commaCnt, SqlWriter writer) {
        if (commaCnt > 1) {
            writer.append(", ");
        }
    }

    public static int getCommaCnt(ConvertConfig config) {
        int cnt = 1;
        if (!WriterUtil.emptyOption(config, "table.compress.level") || WriterUtil.emptyOption(config, "table.orientation")) {
            ++cnt;
        }
        if (!WriterUtil.emptyOption(config, "table.colversion.version")) {
            ++cnt;
        }
        if (!WriterUtil.emptyOption(config, "table.enable.delta")) {
            ++cnt;
        }
        return cnt;
    }

    public static int getConfigCnt(ConvertConfig config, int cnt, String configValueForOrientation) {
        ++cnt;
        if (ConfigUtil.getConfigValue(config, "table.compress.level", null).equals("") || configValueForOrientation.equalsIgnoreCase("column")) {
            ++cnt;
        }
        if (!ConfigUtil.getConfigValue(config, "table.colversion.version", null).equals("") && !configValueForOrientation.equalsIgnoreCase("row")) {
            ++cnt;
        }
        if (!ConfigUtil.getConfigValue(config, "table.enable.delta", null).equals("") && !configValueForOrientation.equalsIgnoreCase("row")) {
            ++cnt;
        }
        return cnt;
    }

    public static boolean emptyOption(ConvertConfig config, String tableOption) {
        return Objects.equals(ConfigUtil.getConfigValue(config, tableOption, null), "");
    }
}

