/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.pg.nodes.AlterOptRoleElem;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import java.util.ArrayList;
import java.util.List;

public class AlterOptRoleElemVisitor
extends AbstractVisitor<AlterOptRoleElem> {
    private final AlterOptRoleElem alterOptRoleElem = new AlterOptRoleElem();

    @Override
    protected AlterOptRoleElem defaultResult() {
        return this.alterOptRoleElem;
    }

    @Override
    public AlterOptRoleElem visitAlterOptRoleElem(PostgreSQLParser.AlterOptRoleElemContext ctx) {
        ArrayList<String> roleList = new ArrayList<String>();
        if (ctx.ENCRYPTED() != null || ctx.UNENCRYPTED() != null) {
            this.alterOptRoleElem.setKeyWord(ctx.ENCRYPTED() != null ? "ENCRYPTED PASSWORD" : "UNENCRYPTED PASSWORD");
            roleList.add(ctx.sConst().getText());
        } else if (ctx.PASSWORD() != null) {
            this.alterOptRoleElem.setKeyWord(ctx.PASSWORD().getText());
            roleList.add(ctx.sConst() != null ? ctx.sConst().getText() : "NULL");
        } else if (ctx.INHERIT() != null) {
            this.alterOptRoleElem.setKeyWord(ctx.INHERIT().getText());
        } else if (ctx.CONNECTION() != null) {
            this.alterOptRoleElem.setKeyWord("CONNECTION LIMIT");
            roleList.add(ctx.signediconst().getText());
        } else if (ctx.VALID() != null) {
            this.alterOptRoleElem.setKeyWord("VALID UNTIL");
            roleList.add(ctx.sConst().getText());
        } else if (ctx.USER() != null) {
            this.alterOptRoleElem.setKeyWord(ctx.USER().getText());
            List<PostgreSQLParser.RoleSpecContext> roleSpecContexts = ctx.roleList().roleSpec();
            for (PostgreSQLParser.RoleSpecContext roleSpecContext : roleSpecContexts) {
                roleList.add(roleSpecContext.getText());
            }
        } else if (ctx.IN_P() != null) {
            this.alterOptRoleElem.setKeyWord("IN RESOURCEGROUP");
            List<PostgreSQLParser.RoleSpecContext> roleSpecContexts = ctx.roleList().roleSpec();
            for (PostgreSQLParser.RoleSpecContext roleSpecContext : roleSpecContexts) {
                roleList.add(roleSpecContext.getText());
            }
        } else {
            this.alterOptRoleElem.setKeyWord(ctx.identifier().getText());
        }
        this.alterOptRoleElem.setRoleList(roleList);
        return this.defaultResult();
    }
}

