/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.pg.nodes.CreateTriggerEvent;
import com.huawei.hwclouds.migration.pg.nodes.CreateTriggerStmt;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import java.util.ArrayList;

public class CreateTriggerStmtVisitor
extends AbstractVisitor<CreateTriggerStmt> {
    private final CreateTriggerStmt result = new CreateTriggerStmt();

    @Override
    protected CreateTriggerStmt defaultResult() {
        return this.result;
    }

    @Override
    public CreateTriggerStmt visitCreatetrigstmt(PostgreSQLParser.CreatetrigstmtContext ctx) {
        this.result.setTriggerName(ctx.name().getText());
        this.result.setTriggerActionTime(CommonUtils.getText(ctx.triggeractiontime()));
        ArrayList<CreateTriggerEvent> triggerEvents = new ArrayList<CreateTriggerEvent>();
        for (PostgreSQLParser.TriggeroneeventContext triggeroneeventContext : ctx.triggerevents().triggeroneevent()) {
            CreateTriggerEvent createTriggerEvent = new CreateTriggerEvent();
            if (triggeroneeventContext.columnlist() != null) {
                createTriggerEvent.setTriggerEvent(triggeroneeventContext.UPDATE().getText() + " " + triggeroneeventContext.OF().getText());
                ArrayList<String> columnList = new ArrayList<String>();
                triggeroneeventContext.columnlist().columnElem().forEach(columnElemContext -> columnList.add(columnElemContext.getText()));
                createTriggerEvent.setColumnList(columnList);
            } else {
                createTriggerEvent.setTriggerEvent(triggeroneeventContext.getText());
            }
            triggerEvents.add(createTriggerEvent);
        }
        this.result.setTriggerEvents(triggerEvents);
        this.result.setTargetName(ctx.qualifiedName().getText());
        this.result.setTriggerForType(ctx.triggerforspec().triggerfortype().getText());
        this.result.setFunctionOrProcedure(ctx.functionOrProcedure().getText());
        this.result.setFuncName(ctx.funcName().getText());
        if (ctx.triggerfuncargs() != null && ctx.triggerfuncargs().triggerfuncarg() != null && !ctx.triggerfuncargs().triggerfuncarg().isEmpty()) {
            ArrayList<String> funcNameArgs = new ArrayList<String>();
            ctx.triggerfuncargs().triggerfuncarg().forEach(triggerfuncargContext -> funcNameArgs.add(triggerfuncargContext.getText()));
            this.result.setFuncNameArgs(funcNameArgs);
        }
        return this.defaultResult();
    }
}

