/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.common.entity.PlaceHolderParam;
import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.common.util.MigrationContextUtil;
import com.huawei.hwclouds.migration.pg.nodes.ArrayExpr;
import com.huawei.hwclouds.migration.pg.nodes.Expr;
import com.huawei.hwclouds.migration.pg.nodes.ExprCase;
import com.huawei.hwclouds.migration.pg.nodes.ExprCon;
import com.huawei.hwclouds.migration.pg.nodes.ExprConst;
import com.huawei.hwclouds.migration.pg.nodes.ExprFunc;
import com.huawei.hwclouds.migration.pg.nodes.ExprIndirection;
import com.huawei.hwclouds.migration.pg.nodes.ExprRow;
import com.huawei.hwclouds.migration.pg.nodes.ExprSelect;
import com.huawei.hwclouds.migration.pg.nodes.Expression;
import com.huawei.hwclouds.migration.pg.nodes.FuncApplication;
import com.huawei.hwclouds.migration.pg.nodes.FuncExprCommonSubExpr;
import com.huawei.hwclouds.migration.pg.nodes.Indirection;
import com.huawei.hwclouds.migration.pg.nodes.OverClause;
import com.huawei.hwclouds.migration.pg.nodes.RowExpr;
import com.huawei.hwclouds.migration.pg.nodes.SelectWithParens;
import com.huawei.hwclouds.migration.pg.nodes.SortClause;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.nodes.WhenClause;
import com.huawei.hwclouds.migration.pg.nodes.WindowSpecification;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.ArrayExprVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.ExprConstVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.FuncApplicationVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.FuncExprCommonSubExprVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.IndirectionVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.SelectWithParensVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.SortClauseVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.WindowSpecificationVisitor;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;

public class ExprVisitor
extends AbstractVisitor<Expr> {
    private Expr expr = new Expr();

    @Override
    protected Expr defaultResult() {
        return this.expr;
    }

    @Override
    public Expr visitExprSelect(PostgreSQLParser.ExprSelectContext ctx) {
        ExprSelect exprSelect = new ExprSelect();
        if (ctx.EXISTS() != null) {
            exprSelect.setKeyWord(ctx.EXISTS().getText());
        } else if (ctx.ARRAY() != null) {
            exprSelect.setKeyWord(ctx.ARRAY().getText());
        } else if (ctx.UNIQUE() != null) {
            exprSelect.setKeyWord(ctx.UNIQUE().getText());
        }
        if (ctx.selectWithParens() != null) {
            exprSelect.setSelectWithParens((SelectWithParens)new SelectWithParensVisitor().visit((ParseTree)ctx.selectWithParens()));
        } else if (ctx.arrayExpr() != null) {
            exprSelect.setArrayExpr((ArrayExpr)new ArrayExprVisitor().visit((ParseTree)ctx.arrayExpr()));
        }
        this.expr.setExprSelect(exprSelect);
        return this.defaultResult();
    }

    @Override
    public Expr visitExprCon(PostgreSQLParser.ExprConContext ctx) {
        ExprCon exprCon = new ExprCon();
        if (ctx.exprConst() != null) {
            exprCon.setExprConst((ExprConst)new ExprConstVisitor().visit((ParseTree)ctx.exprConst()));
        }
        this.expr.setExprCon(exprCon);
        return this.defaultResult();
    }

    @Override
    public Expr visitExprPlsqlName(PostgreSQLParser.ExprPlsqlNameContext ctx) {
        String variableName = ctx.PLSQLVARIABLENAME().getText();
        PlaceHolderParam placeHolderParam = MigrationContextUtil.getPlaceHolderParam();
        Map<String, String> placeHolderMap = placeHolderParam.getPlaceHolderMap();
        String placeHolderFormat = placeHolderParam.getPlaceHolderFormat();
        int index = placeHolderMap.size();
        this.expr.setExprPlsqlName(":" + index);
        if (placeHolderFormat != null && !placeHolderFormat.isEmpty()) {
            placeHolderMap.put(String.valueOf(index), String.format(placeHolderFormat, variableName.substring(1)));
        } else {
            placeHolderMap.put(String.valueOf(index), variableName);
        }
        return this.defaultResult();
    }

    @Override
    public Expr visitExprCase(PostgreSQLParser.ExprCaseContext ctx) {
        ExprCase exprCase = new ExprCase();
        if (ctx.caseExpr().caseArg() != null) {
            exprCase.setCaseArg((Expression)new ExpressionVisitor().visit((ParseTree)ctx.caseExpr().caseArg()));
        }
        SqlNodeList<WhenClause> whenClauseSqlNodeList = new SqlNodeList<WhenClause>();
        for (int i = 0; i < ctx.caseExpr().whenClauseList().whenClause().size(); ++i) {
            WhenClause whenClause = new WhenClause();
            whenClause.setWhenExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx.caseExpr().whenClauseList().whenClause().get(i).expression(0)));
            whenClause.setThenExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx.caseExpr().whenClauseList().whenClause().get(i).expression(1)));
            whenClauseSqlNodeList.addNode(whenClause);
        }
        exprCase.setWhenClauseSqlNodeList(whenClauseSqlNodeList);
        if (ctx.caseExpr().caseDefault() != null) {
            exprCase.setCaseDefault((Expression)new ExpressionVisitor().visit((ParseTree)ctx.caseExpr().caseDefault()));
        }
        this.expr.setExprCase(exprCase);
        return this.defaultResult();
    }

    @Override
    public Expr visitExprFunc(PostgreSQLParser.ExprFuncContext ctx) {
        ExprFunc exprFunc = new ExprFunc();
        PostgreSQLParser.FuncExprContext funcExprContext = ctx.funcExpr();
        if (funcExprContext.funcExprCommonSubExpr() != null) {
            exprFunc.setFuncExprCommonSubExpr((FuncExprCommonSubExpr)new FuncExprCommonSubExprVisitor().visit((ParseTree)funcExprContext.funcExprCommonSubExpr()));
        } else {
            exprFunc.setFuncApplication((FuncApplication)new FuncApplicationVisitor().visit((ParseTree)funcExprContext.funcApplication()));
            if (ctx.funcExpr().funcExprCommonSubExpr() != null) {
                exprFunc.setWithinGroupClause((SortClause)new SortClauseVisitor().visit((ParseTree)ctx.funcExpr().withinGroupClause().sortClause()));
            }
            if (ctx.funcExpr().filterClause() != null) {
                exprFunc.setFilterClause((Expression)new ExpressionVisitor().visit((ParseTree)ctx.funcExpr().filterClause().expression()));
            }
            if (ctx.funcExpr().overClause() != null) {
                OverClause overClause = new OverClause();
                if (ctx.funcExpr().overClause().windowSpecification() != null) {
                    overClause.setWindowSpecification((WindowSpecification)new WindowSpecificationVisitor().visit((ParseTree)ctx.funcExpr().overClause().windowSpecification()));
                }
                if (ctx.funcExpr().overClause().colId() != null) {
                    overClause.setColId(ctx.funcExpr().overClause().getText());
                }
                exprFunc.setOverClause(overClause);
            }
        }
        this.expr.setExprFunc(exprFunc);
        return this.defaultResult();
    }

    @Override
    public Expr visitExprIndirection(PostgreSQLParser.ExprIndirectionContext ctx) {
        ExprIndirection exprIndirection = new ExprIndirection();
        if (ctx.colId() != null) {
            if (!this.parsePlaceHolder(ctx, exprIndirection)) {
                exprIndirection.setColIdOrParam(ctx.colId().getText());
            }
            if (ctx.getText().equalsIgnoreCase("charactervarying") && ctx.colId().colNameKeyword() != null && ctx.colId().colNameKeyword().character() != null) {
                exprIndirection.setColIdOrParam(CommonUtils.getText(ctx.colId().colNameKeyword().character()));
            }
        } else if (ctx.PARAM() != null) {
            exprIndirection.setColIdOrParam(ctx.PARAM().getText());
        } else if (ctx.selectWithParens() != null) {
            exprIndirection.setSelectWithParens((SelectWithParens)new SelectWithParensVisitor().visit((ParseTree)ctx.selectWithParens()));
        } else if (ctx.expression() != null) {
            exprIndirection.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
        }
        if (ctx.indirection() != null) {
            exprIndirection.setIndirection((Indirection)new IndirectionVisitor().visit((ParseTree)ctx.indirection()));
        }
        this.expr.setExprIndirection(exprIndirection);
        return this.defaultResult();
    }

    private boolean parsePlaceHolder(PostgreSQLParser.ExprIndirectionContext ctx, ExprIndirection exprIndirection) {
        PostgreSQLParser.IdentifierContext identifier = ctx.colId().identifier();
        if (identifier != null && (identifier.COLON() != null || identifier.Dollar() != null || this.isSinglePlaceHolder(identifier.getText()))) {
            PlaceHolderParam placeHolderParam = MigrationContextUtil.getPlaceHolderParam();
            Map<String, String> placeHolderMap = placeHolderParam.getPlaceHolderMap();
            String placeHolderFormat = placeHolderParam.getPlaceHolderFormat();
            int index = placeHolderMap.size();
            exprIndirection.setColIdOrParam(":" + index);
            if (placeHolderFormat != null && !placeHolderFormat.isEmpty()) {
                placeHolderMap.put(String.valueOf(index), String.format(placeHolderFormat, identifier.Identifier().getText()));
            } else {
                placeHolderMap.put(String.valueOf(index), ctx.colId().getText());
            }
            return true;
        }
        return false;
    }

    private boolean isSinglePlaceHolder(String identifier) {
        return identifier.startsWith("${") && identifier.endsWith("}") && !identifier.substring(2).contains("${");
    }

    @Override
    public Expr visitExprRow(PostgreSQLParser.ExprRowContext ctx) {
        ExprRow exprRow = new ExprRow();
        exprRow.setFRowExpr(this.getRowExpr(ctx.rowExpr().get(0)));
        if (ctx.rowExpr().size() > 1) {
            exprRow.setSRowExpr(this.getRowExpr(ctx.rowExpr().get(1)));
        }
        this.expr.setExprRow(exprRow);
        return this.defaultResult();
    }

    private RowExpr getRowExpr(PostgreSQLParser.RowExprContext rowExprContext) {
        RowExpr rowExpr = new RowExpr();
        if (rowExprContext.ROW() != null) {
            rowExpr.setKeyWord(rowExprContext.ROW().getText());
        } else if (rowExprContext.GROUPING() != null) {
            rowExpr.setKeyWord(rowExprContext.GROUPING().getText());
        }
        if (rowExprContext.exprList() != null) {
            SqlNodeList<Expression> exprList = new SqlNodeList<Expression>();
            for (int i = 0; i < rowExprContext.exprList().expression().size(); ++i) {
                exprList.addNode((Expression)new ExpressionVisitor().visit((ParseTree)rowExprContext.exprList().expression().get(i)));
            }
            rowExpr.setExprList(exprList);
        }
        return rowExpr;
    }
}

