/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.common.util.CommonUtils;
import com.huawei.hwclouds.migration.pg.nodes.FunctionWithArgTypes;
import com.huawei.hwclouds.migration.pg.nodes.GrantStmt;
import com.huawei.hwclouds.migration.pg.nodes.PrivilegeClause;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.FunctionWithArgTypesVisitor;
import java.util.ArrayList;

public class GrantStmtVisitor
extends AbstractVisitor<GrantStmt> {
    private final GrantStmt result = new GrantStmt();

    @Override
    protected GrantStmt defaultResult() {
        return this.result;
    }

    @Override
    public GrantStmt visitGrantstmt(PostgreSQLParser.GrantstmtContext ctx) {
        PostgreSQLParser.PrivilegesContext privilegesContext = ctx.privileges();
        ArrayList<PrivilegeClause> privileges = new ArrayList<PrivilegeClause>();
        if (privilegesContext.privilegeList() != null) {
            privilegesContext.privilegeList().privilege().forEach(privilegeContext -> privileges.add(this.getPrivilege((PostgreSQLParser.PrivilegeContext)((Object)privilegeContext))));
        } else {
            PrivilegeClause revokePrivilege = new PrivilegeClause();
            if (privilegesContext.PRIVILEGES() != null) {
                revokePrivilege.setPrivilege("ALL PRIVILEGES");
            } else {
                revokePrivilege.setPrivilege("ALL");
            }
            if (privilegesContext.columnlist() != null) {
                ArrayList<String> columnList = new ArrayList<String>();
                privilegesContext.columnlist().columnElem().forEach(columnElemContext -> columnList.add(columnElemContext.getText()));
                revokePrivilege.setColumnList(columnList);
            }
            privileges.add(revokePrivilege);
        }
        this.result.setPrivileges(privileges);
        PostgreSQLParser.PrivilegeTargetContext privilegeTargetContext = ctx.privilegeTarget();
        if (privilegeTargetContext.privilegeTargetType() != null) {
            this.result.setPrivilegeTarget(CommonUtils.getText(privilegeTargetContext.privilegeTargetType()));
        }
        if (privilegeTargetContext.functionWithArgtypesList() != null) {
            SqlNodeList<FunctionWithArgTypes> targetFunctionList = new SqlNodeList<FunctionWithArgTypes>();
            privilegeTargetContext.functionWithArgtypesList().functionWithArgTypes().forEach(functionWithArgTypesContext -> targetFunctionList.addNode(functionWithArgTypesContext.accept(new FunctionWithArgTypesVisitor())));
            this.result.setTargetFunctionList(targetFunctionList);
        } else if (privilegeTargetContext.qualifiedNameList() != null) {
            ArrayList<String> targetColumnList = new ArrayList<String>();
            privilegeTargetContext.qualifiedNameList().qualifiedName().forEach(qualifiedNameContext -> targetColumnList.add(qualifiedNameContext.getText()));
            this.result.setTargetNameList(targetColumnList);
        }
        ArrayList<String> granteeList = new ArrayList<String>();
        ctx.granteeList().grantee().forEach(granteeContext -> granteeList.add(CommonUtils.getText(granteeContext)));
        this.result.setGranteeList(granteeList);
        if (ctx.WITH() != null) {
            this.result.setWithGrantOption(true);
        }
        return this.defaultResult();
    }

    @Override
    public GrantStmt visitGrantrolestmt(PostgreSQLParser.GrantrolestmtContext ctx) {
        ArrayList<PrivilegeClause> privileges = new ArrayList<PrivilegeClause>();
        if (ctx.privilegeList() != null) {
            ctx.privilegeList().privilege().forEach(privilegeContext -> privileges.add(this.getPrivilege((PostgreSQLParser.PrivilegeContext)((Object)privilegeContext))));
        }
        this.result.setPrivileges(privileges);
        ArrayList<String> granteeList = new ArrayList<String>();
        ctx.roleList().roleSpec().forEach(roleSpecContext -> granteeList.add(CommonUtils.getText(roleSpecContext)));
        this.result.setGranteeList(granteeList);
        if (ctx.WITH() != null) {
            this.result.setWithGrantOption(true);
        }
        return this.defaultResult();
    }

    private PrivilegeClause getPrivilege(PostgreSQLParser.PrivilegeContext privilegeContext) {
        PrivilegeClause revokePrivilege = new PrivilegeClause();
        revokePrivilege.setPrivilege(privilegeContext.privilegeType().getText());
        if (privilegeContext.optColumnList() != null) {
            ArrayList<String> columnList = new ArrayList<String>();
            privilegeContext.optColumnList().columnlist().columnElem().forEach(columnElemContext -> columnList.add(columnElemContext.getText()));
            revokePrivilege.setColumnList(columnList);
        }
        return revokePrivilege;
    }
}

