/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.common.annotation.ParseComment;
import com.huawei.hwclouds.migration.common.constant.CommentPosition;
import com.huawei.hwclouds.migration.pg.nodes.Expression;
import com.huawei.hwclouds.migration.pg.nodes.GroupByItem;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.ExpressionVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

@ParseComment(value=CommentPosition.INLIST)
public class GroupByItemVisitor
extends AbstractVisitor<GroupByItem> {
    private final GroupByItem groupByItem = new GroupByItem();

    @Override
    protected GroupByItem defaultResult() {
        return this.groupByItem;
    }

    @Override
    public GroupByItem visitGroupByItem(PostgreSQLParser.GroupByItemContext ctx) {
        SqlNodeList<Expression> exprList = new SqlNodeList<Expression>();
        if (ctx.expression() != null) {
            exprList.addNode((Expression)new ExpressionVisitor().visit((ParseTree)ctx.expression()));
            this.groupByItem.setExprList(exprList);
        } else if (ctx.emptyGroupingSet() != null) {
            this.groupByItem.setEmptyGroupingSet(true);
        } else if (ctx.cubeClause() != null) {
            this.groupByItem.setKeyWord("CUBE");
            List<PostgreSQLParser.ExpressionContext> expressionContexts = ctx.cubeClause().exprList().expression();
            for (PostgreSQLParser.ExpressionContext expressionContext : expressionContexts) {
                exprList.addNode((Expression)new ExpressionVisitor().visit((ParseTree)expressionContext));
            }
            this.groupByItem.setExprList(exprList);
        } else if (ctx.rollupClause() != null) {
            this.groupByItem.setKeyWord("ROLLUP");
            List<PostgreSQLParser.ExpressionContext> expressionContexts = ctx.rollupClause().exprList().expression();
            for (PostgreSQLParser.ExpressionContext expressionContext : expressionContexts) {
                exprList.addNode((Expression)new ExpressionVisitor().visit((ParseTree)expressionContext));
            }
            this.groupByItem.setExprList(exprList);
        } else {
            SqlNodeList<GroupByItem> groupingSetsClause = new SqlNodeList<GroupByItem>();
            List<PostgreSQLParser.GroupByItemContext> groupByItemContexts = ctx.groupingSetsClause().groupByList().groupByItem();
            for (PostgreSQLParser.GroupByItemContext groupByItemContext : groupByItemContexts) {
                groupingSetsClause.addNode((GroupByItem)new GroupByItemVisitor().visit((ParseTree)groupByItemContext));
            }
            this.groupByItem.setGroupingSetsClause(groupingSetsClause);
        }
        return this.defaultResult();
    }
}

