/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.common.annotation.ParseComment;
import com.huawei.hwclouds.migration.pg.nodes.Expression;
import com.huawei.hwclouds.migration.pg.nodes.JoinClause;
import com.huawei.hwclouds.migration.pg.nodes.TableRef;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.TableRefVisitor;
import java.util.ArrayList;
import org.antlr.v4.runtime.tree.ParseTree;

@ParseComment
public class JoinClauseVisitor
extends AbstractVisitor<JoinClause> {
    private JoinClause joinClause = new JoinClause();

    @Override
    protected JoinClause defaultResult() {
        return this.joinClause;
    }

    @Override
    public JoinClause visitJoinClause(PostgreSQLParser.JoinClauseContext ctx) {
        if (ctx.CROSS() != null) {
            this.joinClause.setCrossJoin(true);
        }
        if (ctx.NATURAL() != null) {
            this.joinClause.setNatural(true);
        }
        if (ctx.joinType() != null) {
            this.joinClause.setJoinType(((ParseTree)ctx.joinType().children.get(0)).getText());
            if (ctx.joinType().OUTER_P() != null) {
                this.joinClause.setJoinType(this.joinClause.getJoinType() + " " + ctx.joinType().OUTER_P().getText());
            }
        }
        if (ctx.joinQual() != null) {
            if (ctx.joinQual().nameList() != null) {
                ArrayList<String> nameList = new ArrayList<String>();
                ctx.joinQual().nameList().name().forEach(nameContext -> nameList.add(nameContext.getText()));
                this.joinClause.setNameList(nameList);
            }
            if (ctx.joinQual().expression() != null) {
                this.joinClause.setExpression((Expression)new ExpressionVisitor().visit((ParseTree)ctx.joinQual()));
            }
        }
        if (ctx.tableRef() != null) {
            this.joinClause.setTableRef((TableRef)new TableRefVisitor().visit((ParseTree)ctx.tableRef()));
        }
        return this.defaultResult();
    }
}

