/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.pg.nodes.Expression;
import com.huawei.hwclouds.migration.pg.nodes.PartitionElement;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.SubPartitionElementVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class PartitionElementVisitor
extends AbstractVisitor<PartitionElement> {
    private final PartitionElement partitionElement = new PartitionElement();

    @Override
    protected PartitionElement defaultResult() {
        return this.partitionElement;
    }

    @Override
    public PartitionElement visitPartitionElement(PostgreSQLParser.PartitionElementContext ctx) {
        if (ctx.DEFAULT() != null) {
            this.partitionElement.setDefaultPartition(true);
        }
        if (ctx.name() != null) {
            this.partitionElement.setPartitionName(ctx.name().getText());
        }
        if (ctx.VALUES() != null) {
            if (ctx.LESS_P() != null && ctx.THAN_P() != null) {
                SqlNodeList<Expression> lessThanExprList = new SqlNodeList<Expression>();
                ctx.lessThanExprList.expression().forEach(expressionContext -> lessThanExprList.addNode((Expression)new ExpressionVisitor().visit((ParseTree)expressionContext)));
                this.partitionElement.setLessThanExprList(lessThanExprList);
            } else {
                SqlNodeList<Expression> valuesExprList = new SqlNodeList<Expression>();
                ctx.valuesExprList.expression().forEach(expressionContext -> valuesExprList.addNode((Expression)new ExpressionVisitor().visit((ParseTree)expressionContext)));
                this.partitionElement.setValuesExprList(valuesExprList);
                this.partitionElement.setValuesExprListStr(ctx.valuesExprList.getText());
            }
        }
        if (ctx.START() != null) {
            this.partitionElement.setPartitionStartExpr((Expression)new ExpressionVisitor().visit((ParseTree)ctx.partitionStartExpr));
            if (ctx.startRangeParam != null) {
                this.partitionElement.setStartRangeParam(ctx.startRangeParam.getText());
            }
        }
        if (ctx.END_P() != null) {
            this.partitionElement.setPartitionEndExpr((Expression)new ExpressionVisitor().visit((ParseTree)ctx.partitionEndExpr));
            if (ctx.endRangeParam != null) {
                this.partitionElement.setEndRangeParam(ctx.endRangeParam.getText());
            }
        }
        if (ctx.EVERY_P() != null) {
            this.partitionElement.setPartitionEveryExpr((Expression)new ExpressionVisitor().visit((ParseTree)ctx.partitionEveryExpr));
        }
        if (ctx.subPartitionElement() != null && !ctx.subPartitionElement().isEmpty()) {
            SqlNodeList<PartitionElement> subPartitionElementList = new SqlNodeList<PartitionElement>();
            ctx.subPartitionElement().forEach(subPartitionElementContext -> subPartitionElementList.addNode((PartitionElement)new SubPartitionElementVisitor().visit((ParseTree)subPartitionElementContext)));
            this.partitionElement.setSubPartitionElementList(subPartitionElementList);
        }
        return this.defaultResult();
    }
}

