/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.parser.visitor;

import com.huawei.hwclouds.migration.pg.nodes.Condition;
import com.huawei.hwclouds.migration.pg.nodes.FromClause;
import com.huawei.hwclouds.migration.pg.nodes.GroupClause;
import com.huawei.hwclouds.migration.pg.nodes.IntoClause;
import com.huawei.hwclouds.migration.pg.nodes.SqlExpression;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.nodes.TargetList;
import com.huawei.hwclouds.migration.pg.nodes.WindowClause;
import com.huawei.hwclouds.migration.pg.nodes.WindowDefinition;
import com.huawei.hwclouds.migration.pg.nodes.WindowSpecification;
import com.huawei.hwclouds.migration.pg.parser.PostgreSQLParser;
import com.huawei.hwclouds.migration.pg.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.ConditionVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.FromClauseVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.GroupClauseVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.IntoClauseVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.TargetListVisitor;
import com.huawei.hwclouds.migration.pg.parser.visitor.WindowSpecificationVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class SqlExpressionVisitor
extends AbstractVisitor<SqlExpression> {
    private final SqlExpression sqlExpression = new SqlExpression();

    @Override
    protected SqlExpression defaultResult() {
        return this.sqlExpression;
    }

    @Override
    public SqlExpression visitSqlExpression(PostgreSQLParser.SqlExpressionContext ctx) {
        this.sqlExpression.setTargetList((TargetList)new TargetListVisitor().visit((ParseTree)ctx.targetList()));
        if (ctx.intoClause() != null) {
            this.sqlExpression.setIntoClause((IntoClause)new IntoClauseVisitor().visit((ParseTree)ctx.intoClause()));
        }
        if (ctx.fromClause() != null) {
            this.sqlExpression.setFromClause((FromClause)new FromClauseVisitor().visit((ParseTree)ctx.fromClause()));
        }
        if (ctx.whereClause() != null) {
            this.sqlExpression.setWhereClause((Condition)new ConditionVisitor().visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.groupClause() != null) {
            this.sqlExpression.setGroupClause((GroupClause)new GroupClauseVisitor().visit((ParseTree)ctx.groupClause()));
        }
        if (ctx.havingClause() != null) {
            this.sqlExpression.setHavingClause((Condition)new ConditionVisitor().visit((ParseTree)ctx.havingClause()));
        }
        if (ctx.windowClause() != null) {
            WindowClause windowClause = new WindowClause();
            SqlNodeList<WindowDefinition> windowDefinitionList = new SqlNodeList<WindowDefinition>();
            List<PostgreSQLParser.WindowDefinitionContext> windowDefinitionContexts = ctx.windowClause().windowDefinitionList().windowDefinition();
            for (PostgreSQLParser.WindowDefinitionContext windowDefinitionContext : windowDefinitionContexts) {
                WindowDefinition windowDefinition = new WindowDefinition();
                windowDefinition.setColId(windowDefinitionContext.colId().getText());
                windowDefinition.setWindowSpecification((WindowSpecification)new WindowSpecificationVisitor().visit((ParseTree)windowDefinitionContext.windowSpecification()));
                windowDefinitionList.addNode(windowDefinition);
            }
            windowClause.setWindowDefinitionList(windowDefinitionList);
            this.sqlExpression.setWindowClause(windowClause);
        }
        return this.defaultResult();
    }
}

