/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.WriterUtil;
import com.huawei.hwclouds.migration.pg.nodes.BExpr;
import com.huawei.hwclouds.migration.pg.nodes.ColConstraint;
import com.huawei.hwclouds.migration.pg.nodes.ColumnDef;
import com.huawei.hwclouds.migration.pg.nodes.ConstraintElem;
import com.huawei.hwclouds.migration.pg.nodes.CreateStmt;
import com.huawei.hwclouds.migration.pg.nodes.Distkey;
import com.huawei.hwclouds.migration.pg.nodes.DistributeCol;
import com.huawei.hwclouds.migration.pg.nodes.DistributeColList;
import com.huawei.hwclouds.migration.pg.nodes.OptWith;
import com.huawei.hwclouds.migration.pg.nodes.RelOptionElem;
import com.huawei.hwclouds.migration.pg.nodes.RelOptions;
import com.huawei.hwclouds.migration.pg.nodes.SimpleTypeName;
import com.huawei.hwclouds.migration.pg.nodes.Sortkey;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.nodes.SqlTypeName;
import com.huawei.hwclouds.migration.pg.nodes.TableCons;
import com.huawei.hwclouds.migration.pg.nodes.TableElement;
import com.huawei.hwclouds.migration.pg.unparser.DWSTypeName;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.util.CreateIndexUtil;
import com.huawei.hwclouds.migration.pg.util.DistributeListUtil;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateStmt.class)
public class CreateStmtUnParser
implements UnParser<CreateStmt> {
    @Override
    public void unParse(CreateStmt sqlNode, SqlWriter writer, UnParserContext context) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        this.processColSequence(sqlNode, writer, context);
        writer.append("CREATE ");
        if (sqlNode.getTableType() != null) {
            writer.append(sqlNode.getTableType()).writeSpace();
        }
        writer.append("TABLE ");
        if (sqlNode.isIfNotExists()) {
            writer.append("IF NOT EXISTS ");
        }
        writer.append(sqlNode.getTableName()).writeSpace();
        if (sqlNode.getSelectStmt() != null) {
            if (sqlNode.getDistkey() != null) {
                this.distributeByClause(sqlNode, writer, context, config);
            }
            writer.append("AS ");
            sqlNode.getSelectStmt().unParse(writer, context);
            if (sqlNode.getSortClause() != null) {
                writer.writeSpace();
                sqlNode.getSortClause().unParse(writer, context);
            }
            return;
        }
        CreateStmt createStmt = this.checkPrimaryKeyAndUnique(sqlNode);
        String logicalPartitionColId = null;
        if (sqlNode.getPartitionKey() != null && sqlNode.getPartitionKey().isLogical()) {
            logicalPartitionColId = sqlNode.getPartitionKey().getColId();
            sqlNode.getPartitionKey().setPartitionType("RANGE");
        }
        if (sqlNode.getTableElementList() != null) {
            writer.append("(");
            writer.newLine();
            ArrayList<String> colids = new ArrayList<String>();
            List<TableElement> tableElementNodes = sqlNode.getTableElementList().getNodes();
            for (int i = 0; i < tableElementNodes.size(); ++i) {
                TableElement tableElement = tableElementNodes.get(i);
                tableElement.unParse(writer, context);
                if (tableElement.getColumnDef() != null && tableElement.getColumnDef().getColConstraintSqlNodeList() != null) {
                    this.processColumnDistSortkey(tableElement, colids, sqlNode, writer);
                }
                if (i != sqlNode.getTableElementList().getNodes().size() - 1) {
                    writer.append(", ").newLine();
                }
                if (logicalPartitionColId == null || tableElement.getColumnDef() == null || !logicalPartitionColId.equals(tableElement.getColumnDef().getColId())) continue;
                this.processPartitionTimeFormat(sqlNode, tableElement.getColumnDef());
            }
            if (sqlNode.getSortkey() != null) {
                this.createTableSortkey(sqlNode, writer);
            }
            writer.append(") ");
        }
        if (sqlNode.getOptWith() != null) {
            sqlNode.getOptWith().unParse(writer, context);
        } else {
            this.dealWithTableOption(writer);
        }
        this.distributeByClause(sqlNode, writer, context, config);
        if (sqlNode.getPartitionKey() != null) {
            writer.newLine();
            sqlNode.getPartitionKey().unParse(writer, context);
        }
        this.createIndexOfRemoveUnique(sqlNode, writer, createStmt);
    }

    private void processColumnDistSortkey(TableElement elementNode, List<String> colids, CreateStmt sqlNode, SqlWriter writer) {
        for (int j = 0; j < elementNode.getColumnDef().getColConstraintSqlNodeList().getNodes().size(); ++j) {
            if (elementNode.getColumnDef().getColConstraintSqlNodeList().getNodes().get(j).getColConstraintElem() == null) continue;
            if (elementNode.getColumnDef().getColConstraintSqlNodeList().getNodes().get(j).getColConstraintElem().getKeyWord().equalsIgnoreCase("DISTKEY")) {
                Distkey distkey = new Distkey();
                ArrayList<String> colList = new ArrayList<String>();
                colList.add(elementNode.getColumnDef().getColId());
                distkey.setColumnList(colList);
                sqlNode.setDistkey(distkey);
                continue;
            }
            if (!elementNode.getColumnDef().getColConstraintSqlNodeList().getNodes().get(j).getColConstraintElem().getKeyWord().equalsIgnoreCase("SORTKEY")) continue;
            Sortkey sortkey = new Sortkey();
            sortkey.setSortkey("SORTKEY");
            colids.add(elementNode.getColumnDef().getColId());
            sortkey.setColids(colids);
            sqlNode.setSortkey(sortkey);
        }
    }

    private void processColSequence(CreateStmt sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getTableElementList() == null || sqlNode.getTableElementList().isEmpty()) {
            return;
        }
        for (TableElement tableElement : sqlNode.getTableElementList().getNodes()) {
            if (tableElement.getColumnDef() == null || tableElement.getColumnDef().getColConstraintSqlNodeList() == null || tableElement.getColumnDef().getColConstraintSqlNodeList().isEmpty()) continue;
            for (ColConstraint colConstraint : tableElement.getColumnDef().getColConstraintSqlNodeList().getNodes()) {
                BExpr bExpr;
                if (colConstraint.getColConstraintElem() == null || (bExpr = colConstraint.getColConstraintElem().getBExpr()) == null || bExpr.getExpr() == null || bExpr.getExpr().getExprFunc() == null || bExpr.getExpr().getExprFunc().getFuncExprCommonSubExpr() == null || !bExpr.getExpr().getExprFunc().getFuncExprCommonSubExpr().getFunctionExprName().equalsIgnoreCase("nextval")) continue;
                SqlWriter sequenceNameWriter = writer.cloneEmpty();
                bExpr.getExpr().getExprFunc().getFuncExprCommonSubExpr().getExpression().unParse(sequenceNameWriter, context);
                String sequenceName = sequenceNameWriter.toSqlString().getSql().replace("'", "").replace(" ", "").replace("::regclass", "");
                writer.append("CREATE SEQUENCE IF NOT EXISTS").writeSpace().append(sequenceName).sqlEnd().newLine();
            }
        }
    }

    private void processPartitionTimeFormat(CreateStmt sqlNode, ColumnDef columnDef) {
        this.addOptWith(sqlNode, "period", "'1 day'");
        SimpleTypeName simpleTypeName = columnDef.getTypeName().getSimpleTypeName();
        if (simpleTypeName.getTimeType() != null) {
            if (simpleTypeName.getTimeType().getTypeName() != SqlTypeName.TIME) {
                return;
            }
        } else if (simpleTypeName.getCharacterType() != null) {
            if (simpleTypeName.getCharacterType().getCharacterName() == SqlTypeName.VARCHAR || simpleTypeName.getCharacterType().getCharacterName() == SqlTypeName.CHARACTERVARYING || simpleTypeName.getCharacterType().getCharacterName() == SqlTypeName.TEXT) {
                this.addOptWith(sqlNode, "time_format", "'YYYY-MM-DD'");
                return;
            }
        } else if (simpleTypeName.getNumericType() != null && (simpleTypeName.getNumericType().getNumeric() == SqlTypeName.INT || simpleTypeName.getNumericType().getNumeric() == SqlTypeName.INT4 || simpleTypeName.getNumericType().getNumeric() == SqlTypeName.INT8 || simpleTypeName.getNumericType().getNumeric() == SqlTypeName.INTEGER || simpleTypeName.getNumericType().getNumeric() == SqlTypeName.BIGINT)) {
            this.addOptWith(sqlNode, "time_format", "'YYYYMMDD'");
            return;
        }
        throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Partition Key must be of type TIMESTAMP/TIMESTAMPTZ/DATE/INT/BIGINT/VARCHAR/TEXT");
    }

    private void addOptWith(CreateStmt sqlNode, String key, String value) {
        RelOptionElem newRelOptionElem = new RelOptionElem();
        newRelOptionElem.setFColLabel(key);
        newRelOptionElem.setDefArg(value);
        if (sqlNode.getOptWith() != null && sqlNode.getOptWith().getWithOrWithOut().equals("WITH")) {
            for (RelOptionElem relOptionElem : sqlNode.getOptWith().getReloptions().getRelOptionElemSqlNodeList().getNodes()) {
                if (!relOptionElem.getFColLabel().equals(key)) continue;
                relOptionElem.setDefArg(value);
                return;
            }
            sqlNode.getOptWith().getReloptions().getRelOptionElemSqlNodeList().addNode(newRelOptionElem);
        } else {
            OptWith optwith = new OptWith();
            optwith.setWithOrWithOut("WITH");
            RelOptions reloptions = new RelOptions();
            SqlNodeList<RelOptionElem> relOptionElemSqlNodeList = new SqlNodeList<RelOptionElem>();
            relOptionElemSqlNodeList.addNode(newRelOptionElem);
            reloptions.setRelOptionElemSqlNodeList(relOptionElemSqlNodeList);
            optwith.setReloptions(reloptions);
            sqlNode.setOptWith(optwith);
        }
    }

    private void createTableSortkey(CreateStmt sqlNode, SqlWriter writer) {
        writer.append(", PARTIAL CLUSTER KEY");
        writer.append("(");
        if (sqlNode.getSortkey().getColids() != null) {
            int colidSize = Math.min(sqlNode.getSortkey().getColids().size(), 2);
            for (int i = 0; i < colidSize; ++i) {
                writer.append(sqlNode.getSortkey().getColids().get(i));
                if (i == colidSize - 1) continue;
                writer.append(", ");
            }
        }
        writer.append(")");
    }

    private void createIndexOfRemoveUnique(CreateStmt sqlNode, SqlWriter writer, CreateStmt createStmt) {
        SqlNodeList<TableElement> tableElementList = createStmt.getTableElementList();
        for (int i = 0; i < tableElementList.getNodes().size(); ++i) {
            ConstraintElem constraintElem;
            if (tableElementList.getNodes().get(i).getColumnDef() != null) {
                writer.sqlEnd();
                String indexName = CreateIndexUtil.getIndexName(sqlNode, tableElementList.getNodes().get(i));
                String columnName = tableElementList.getNodes().get(i).getColumnDef().getColId();
                writer.newLine();
                writer.append("CREATE INDEX ");
                writer.append(QuoteUtils.addDoubleQuote(indexName));
                writer.writeSpace().append("ON ").append(sqlNode.getTableName()).writeSpace();
                writer.append("(").append(QuoteUtils.addDoubleQuote(columnName)).append(")");
                continue;
            }
            if (tableElementList.getNodes().get(i).getTableconstraint() == null || (constraintElem = tableElementList.getNodes().get(i).getTableconstraint().getConstraintElem()).getUkOrPkTableConstraint() == null || !constraintElem.getUkOrPkTableConstraint().getKeyType().equalsIgnoreCase("unique")) continue;
            writer.sqlEnd();
            String indexName = CreateIndexUtil.getIndexNameConstraint(tableElementList.getNodes().get(i).getTableconstraint(), writer);
            writer.newLine();
            writer.append("CREATE INDEX ");
            writer.append(QuoteUtils.addDoubleQuote(indexName));
            writer.writeSpace().append("ON ").append(sqlNode.getTableName()).writeSpace();
            writer.append("(").append(tableElementList.getNodes().get(i).getColumnDef().getColId()).append(")");
        }
    }

    private CreateStmt checkPrimaryKeyAndUnique(CreateStmt sqlNode) {
        int j;
        int i;
        CreateStmt createStmt = new CreateStmt();
        DistributeColList distributeColList = sqlNode.getDistributeColList();
        SqlNodeList<TableElement> tableEleWithUK = new SqlNodeList<TableElement>();
        List<TableElement> nodes = sqlNode.getTableElementList().getNodes();
        if (distributeColList.isExistPrimaryKey() && distributeColList.getUniqueCntForCol() + distributeColList.getUniqueCntForTable() > 0) {
            for (i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i).getColumnDef() == null || nodes.get(i).getColumnDef().getColConstraintSqlNodeList() == null) continue;
                for (j = 0; j < nodes.get(i).getColumnDef().getColConstraintSqlNodeList().getNodes().size(); ++j) {
                    if (nodes.get(i).getColumnDef().getColConstraintSqlNodeList().getNodes().get(j).getColConstraintElem() == null || !nodes.get(i).getColumnDef().getColConstraintSqlNodeList().getNodes().get(j).getColConstraintElem().getKeyWord().equalsIgnoreCase("unique")) continue;
                    tableEleWithUK.addNode(nodes.get(i));
                    nodes.get(i).getColumnDef().getColConstraintSqlNodeList().getNodes().remove(j);
                }
            }
        }
        if (!distributeColList.isExistPrimaryKey() && distributeColList.getUniqueCntForCol() + distributeColList.getUniqueCntForTable() > 1) {
            for (i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i).getColumnDef() != null && nodes.get(i).getColumnDef().getColConstraintSqlNodeList() != null) {
                    for (j = 0; j < nodes.get(i).getColumnDef().getColConstraintSqlNodeList().getNodes().size(); ++j) {
                        if (nodes.get(i).getColumnDef().getColConstraintSqlNodeList().getNodes().get(j).getColConstraintElem() == null || !nodes.get(i).getColumnDef().getColConstraintSqlNodeList().getNodes().get(j).getColConstraintElem().getKeyWord().equalsIgnoreCase("unique")) continue;
                        tableEleWithUK.addNode(nodes.get(i));
                        nodes.get(i).getColumnDef().getColConstraintSqlNodeList().getNodes().remove(j);
                    }
                }
                if (nodes.get(i).getTableconstraint() == null || nodes.get(i).getTableconstraint().getConstraintElem().getUkOrPkTableConstraint() == null || !nodes.get(i).getTableconstraint().getConstraintElem().getUkOrPkTableConstraint().getKeyType().equalsIgnoreCase("unique")) continue;
                tableEleWithUK.addNode(nodes.get(i));
                nodes.set(i, null);
            }
        }
        createStmt.setTableElementList(tableEleWithUK);
        return createStmt;
    }

    private void distributeByClause(CreateStmt sqlNode, SqlWriter writer, UnParserContext context, ConvertConfig config) {
        if (sqlNode.getDistkey() != null) {
            if (sqlNode.getDistkey().isRandom()) {
                writer.append("DISTRIBUTE BY ROUNDROBIN ");
            } else if (sqlNode.getDistkey().isReplicated()) {
                writer.append("DISTRIBUTE BY REPLICATION ");
            } else {
                writer.append("DISTRIBUTE BY HASH(");
                for (int i = 0; i < sqlNode.getDistkey().getColumnList().size(); ++i) {
                    writer.append(sqlNode.getDistkey().getColumnList().get(i));
                    if (i == sqlNode.getDistkey().getColumnList().size() - 1) continue;
                    writer.append(", ");
                }
                writer.append(")");
            }
            return;
        }
        if (sqlNode.getDiststyle() != null) {
            if (sqlNode.getDiststyle().getStyle().equalsIgnoreCase("REPLICATION")) {
                writer.append("DISTRIBUTE BY REPLICATION ");
            } else {
                writer.append("DISTRIBUTE BY ROUNDROBIN ");
            }
            return;
        }
        DistributeListUtil.getDistributeColList(sqlNode);
        if (!ConfigUtil.getConfigValue(config, "table.type", null).equals("")) {
            if (ConfigUtil.getConfigValue(config, "table.type", null).equalsIgnoreCase("REPLICATION")) {
                writer.append("DISTRIBUTE BY REPLICATION ");
            } else if (ConfigUtil.getConfigValue(config, "table.type", null).equalsIgnoreCase("ROUND-ROBIN")) {
                DistributeColList distributeColList = sqlNode.getDistributeColList();
                if (this.havePkOrUk(distributeColList) || context.getDisKeyCol() != null) {
                    this.appendHashList(sqlNode, writer, context);
                } else {
                    writer.append("DISTRIBUTE BY ROUNDROBIN ");
                }
            } else if (ConfigUtil.getConfigValue(config, "table.type", null).equalsIgnoreCase("HASH")) {
                this.appendHashList(sqlNode, writer, context);
            }
        }
    }

    private boolean havePkOrUk(DistributeColList distributeColList) {
        return distributeColList.isExistPrimaryKey() || distributeColList.getUniqueCntForTable() != 0 || distributeColList.getUniqueCntForCol() != 0;
    }

    private void appendHashList(CreateStmt sqlNode, SqlWriter writer, UnParserContext context) {
        DistributeColList distributeColList = sqlNode.getDistributeColList();
        List<DistributeCol> nodesForCol = distributeColList.getDistributeColSqlNodeList().getNodes();
        TableCons tableCons = distributeColList.getTableCons();
        ArrayList<String> disList = new ArrayList<String>();
        if (distributeColList.isExistPrimaryKey()) {
            this.disListWithPK(writer, nodesForCol, tableCons, disList, context);
        } else if (distributeColList.getUniqueCntForTable() != 0 || distributeColList.getUniqueCntForCol() != 0) {
            this.disListWithUK(writer, distributeColList, nodesForCol, tableCons, disList);
        } else {
            this.disListWithOutUK(sqlNode, writer, disList, context);
        }
    }

    private void disListWithUK(SqlWriter writer, DistributeColList distributeColList, List<DistributeCol> nodesForCol, TableCons tableCons, List<String> disList) {
        if (distributeColList.getUniqueCntForCol() == 1) {
            for (DistributeCol distributeCol : nodesForCol) {
                if (!distributeCol.getKeyword().equalsIgnoreCase("unique") || !DWSTypeName.checkColType(distributeCol.getColType())) continue;
                disList.add(distributeCol.getColName());
            }
        } else if (distributeColList.getUniqueCntForCol() > 1) {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "UniqueIndex of distribute table must contain hash distribution column");
        }
        if (tableCons != null && tableCons.getUniqueOrPrimary().equalsIgnoreCase("unique")) {
            for (int i = 0; i < tableCons.getColList().size(); ++i) {
                if (!DWSTypeName.checkColType(tableCons.getColList().get(i).getTypeName())) continue;
                disList.add(tableCons.getColList().get(i).getColName());
            }
        }
        if (disList.size() > 0) {
            writer.append("DISTRIBUTE BY HASH");
            writer.append("(");
            for (int i = 0; i < disList.size(); ++i) {
                writer.append(disList.get(i));
                if (i == disList.size() - 1) continue;
                writer.append(", ");
            }
        } else {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Col type with uk not a hash distributable data type");
        }
        writer.append(") ");
    }

    private void disListWithOutUK(CreateStmt sqlNode, SqlWriter writer, List<String> disList, UnParserContext context) {
        if (context.getDisKeyCol() != null) {
            this.disColWithRelOptions(disList, context.getDisKeyCol());
        } else {
            List<TableElement> nodesForTableElement = sqlNode.getTableElementList().getNodes();
            for (TableElement node : nodesForTableElement) {
                if (node.getColumnDef() == null || !DWSTypeName.checkColType(node.getColumnDef().getTypeName())) continue;
                disList.add(node.getColumnDef().getColId());
                break;
            }
        }
        if (disList.size() > 0) {
            writer.append("DISTRIBUTE BY HASH");
            writer.append("(");
            for (int i = 0; i < disList.size(); ++i) {
                writer.append(disList.get(i));
                if (i == disList.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
    }

    private void disColWithRelOptions(List<String> disList, String disKeyCol) {
        disKeyCol = QuoteUtils.removeAllQuote(disKeyCol);
        String[] colList = disKeyCol.split(",");
        disList.addAll(Arrays.asList(colList));
    }

    private void disListWithPK(SqlWriter writer, List<DistributeCol> nodesForCol, TableCons tableCons, List<String> disList, UnParserContext context) {
        if (context.getDisKeyCol() != null) {
            this.disColWithRelOptions(disList, context.getDisKeyCol());
        } else {
            for (DistributeCol distributeCol : nodesForCol) {
                if (!distributeCol.getKeyword().equalsIgnoreCase("primary key") || !DWSTypeName.checkColType(distributeCol.getColType())) continue;
                disList.add(distributeCol.getColName());
            }
            if (tableCons != null && tableCons.getUniqueOrPrimary().equalsIgnoreCase("primary key")) {
                for (int i = 0; i < tableCons.getColList().size(); ++i) {
                    if (!DWSTypeName.checkColType(tableCons.getColList().get(i).getTypeName())) continue;
                    disList.add(tableCons.getColList().get(i).getColName());
                }
            }
        }
        if (disList.size() > 0) {
            writer.append("DISTRIBUTE BY HASH");
            writer.append("(");
            for (int i = 0; i < disList.size(); ++i) {
                writer.append(disList.get(i));
                if (i == disList.size() - 1) continue;
                writer.append(", ");
            }
        } else {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "Col type with uk not a hash distributable data type");
        }
        writer.append(") ");
    }

    private void dealWithTableOption(SqlWriter writer) {
        ConvertConfig config = writer.getConfig("param.config.flag");
        int commaCnt = WriterUtil.getCommaCnt(config);
        writer.append("WITH ( ");
        writer.append("orientation = ").append(ConfigUtil.getConfigValue(config, "table.orientation", null).equals("") ? "COLUMN" : ConfigUtil.getConfigValue(config, "table.orientation", null));
        WriterUtil.writerNoOptionComma(commaCnt, writer);
        --commaCnt;
        String tableCompressLevel = ConfigUtil.getConfigValue(config, "table.compress.level", null);
        if (tableCompressLevel != null && !tableCompressLevel.isEmpty()) {
            writer.append("compression = ").append(tableCompressLevel);
            WriterUtil.writerNoOptionComma(commaCnt, writer);
            --commaCnt;
        }
        if (!WriterUtil.emptyOption(config, "table.colversion.version")) {
            writer.append("colversion = ").append(ConfigUtil.getConfigValue(config, "table.colversion.version", null));
            WriterUtil.writerNoOptionComma(commaCnt, writer);
            --commaCnt;
        }
        if (!WriterUtil.emptyOption(config, "table.enable.delta")) {
            writer.append("enable_delta = ").append(ConfigUtil.getConfigValue(config, "table.enable.delta", null));
            WriterUtil.writerNoOptionComma(commaCnt, writer);
        }
        writer.append(") ");
    }
}

