/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.CreateTriggerEvent;
import com.huawei.hwclouds.migration.pg.nodes.CreateTriggerStmt;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=CreateTriggerStmt.class)
public class CreateTriggerStmtUnParser
implements UnParser<CreateTriggerStmt> {
    @Override
    public void unParse(CreateTriggerStmt sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("CREATE TRIGGER").writeSpace();
        writer.append(sqlNode.getTriggerName()).writeSpace();
        writer.append(sqlNode.getTriggerActionTime()).writeSpace();
        List<CreateTriggerEvent> triggerEvents = sqlNode.getTriggerEvents();
        int size = triggerEvents.size();
        for (int i = 0; i < size; ++i) {
            CreateTriggerEvent triggerEvent = triggerEvents.get(i);
            writer.append(triggerEvent.getTriggerEvent()).writeSpace();
            if (triggerEvent.getColumnList() != null && !triggerEvent.getColumnList().isEmpty()) {
                writer.append(String.join((CharSequence)",", triggerEvent.getColumnList())).writeSpace();
            }
            if (i == size - 1) continue;
            writer.append("OR").writeSpace();
        }
        writer.append("ON").writeSpace();
        writer.append(sqlNode.getTargetName()).writeSpace();
        writer.append("FOR EACH").writeSpace().append(sqlNode.getTriggerForType()).writeSpace();
        writer.append("EXECUTE").writeSpace();
        writer.append(sqlNode.getFunctionOrProcedure()).writeSpace();
        writer.append(sqlNode.getFuncName()).append("(");
        if (sqlNode.getFuncNameArgs() != null) {
            writer.append(String.join((CharSequence)",", sqlNode.getFuncNameArgs()));
        }
        writer.append(")");
    }
}

