/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.DropStmt;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=DropStmt.class)
public class DropStmtUnParser
implements UnParser<DropStmt> {
    @Override
    public void unParse(DropStmt sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("DROP ").append(sqlNode.getObjectTypeAnyName()).writeSpace();
        if (sqlNode.isIfExists()) {
            writer.append("IF EXISTS ");
        }
        if (sqlNode.getName() != null) {
            writer.append(sqlNode.getName()).writeSpace();
        }
        if (sqlNode.isExistsOn()) {
            writer.append("ON ");
        }
        if (sqlNode.getAnyNameList() != null) {
            for (int i = 0; i < sqlNode.getAnyNameList().size(); ++i) {
                writer.append(sqlNode.getAnyNameList().get(i)).writeSpace();
                if (i == sqlNode.getAnyNameList().size() - 1) continue;
                writer.append(", ");
            }
        } else {
            for (int i = 0; i < sqlNode.getTypeNameList().getNodes().size(); ++i) {
                sqlNode.getTypeNameList().getNodes().get(i).unParse(writer, context);
                if (i == sqlNode.getTypeNameList().getNodes().size() - 1) continue;
                writer.append(", ");
            }
        }
        if (sqlNode.getOptDropBehavior() != null) {
            writer.append(sqlNode.getOptDropBehavior()).writeSpace();
        }
    }
}

