/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.DataTypeBase;
import com.huawei.hwclouds.migration.pg.nodes.Expr;
import com.huawei.hwclouds.migration.pg.nodes.ExprCaret;
import com.huawei.hwclouds.migration.pg.nodes.ExprCompare;
import com.huawei.hwclouds.migration.pg.nodes.ExprCon;
import com.huawei.hwclouds.migration.pg.nodes.ExprConst;
import com.huawei.hwclouds.migration.pg.nodes.ExprFunc;
import com.huawei.hwclouds.migration.pg.nodes.ExprIsNot;
import com.huawei.hwclouds.migration.pg.nodes.Expression;
import com.huawei.hwclouds.migration.pg.nodes.FuncApplication;
import com.huawei.hwclouds.migration.pg.nodes.FuncArgExpr;
import com.huawei.hwclouds.migration.pg.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.io.IOException;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=FuncApplication.class)
public class FuncApplicationUnParser
implements UnParser<FuncApplication> {
    @Override
    public void unParse(FuncApplication sqlNode, SqlWriter writer, UnParserContext context) {
        context.setFuncName(sqlNode.getFuncName());
        this.funcConvertWithPara(sqlNode, writer);
        if (!this.funcConvertWithOutPara(sqlNode, writer)) {
            return;
        }
        writer.append(sqlNode.getFuncName()).append("( ");
        if (sqlNode.isExistStar()) {
            writer.append("*");
        } else if (sqlNode.getAllOrDistinct() != null) {
            writer.append(sqlNode.getAllOrDistinct()).writeSpace();
            for (int i = 0; i < sqlNode.getFuncArgList().getNodes().size(); ++i) {
                sqlNode.getFuncArgList().getNodes().get(i).unParse(writer, context);
                if (i == sqlNode.getFuncArgList().getNodes().size() - 1) continue;
                writer.append(", ");
            }
        } else if (sqlNode.getTypeOfVariadic() != null && sqlNode.getTypeOfVariadic().equalsIgnoreCase("front")) {
            writer.append("VARIADIC ");
            sqlNode.getFuncArgExpr().unParse(writer, context);
            if (sqlNode.getSortClause() != null) {
                sqlNode.getSortClause().unParse(writer, context);
            }
        } else {
            SqlNodeList<FuncArgExpr> funcArgExprList;
            if (sqlNode.getFuncName() != null && sqlNode.getFuncName().equalsIgnoreCase("timezone") && sqlNode.getFuncArgList().getNodes().size() == 3) {
                SqlNodeList<FuncArgExpr> funcArgExprSqlNodeList = new SqlNodeList<FuncArgExpr>();
                funcArgExprList = sqlNode.getFuncArgList();
                for (int i = 1; i < funcArgExprList.getNodes().size(); ++i) {
                    funcArgExprSqlNodeList.addNode(funcArgExprList.getNodes().get(i));
                }
                sqlNode.setFuncArgList(funcArgExprSqlNodeList);
            }
            if (sqlNode.getFuncArgList() != null) {
                for (int i = 0; i < sqlNode.getFuncArgList().getNodes().size(); ++i) {
                    sqlNode.getFuncArgList().getNodes().get(i).unParse(writer, context);
                    if (i == sqlNode.getFuncArgList().getNodes().size() - 1) continue;
                    if (sqlNode.getFuncName().equalsIgnoreCase("position")) {
                        writer.append("in ");
                        continue;
                    }
                    if (sqlNode.getFuncName().equalsIgnoreCase("ADDDATE") && i == 1 && (funcArgExprList = sqlNode.getFuncArgList()).getNodes().get(1).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon().getExprConst().getConstValue().contains("interval")) continue;
                    writer.append(", ");
                }
            }
            if (sqlNode.getFuncArgExpr() != null) {
                writer.append(", VARIADIC ");
                sqlNode.getFuncArgExpr().unParse(writer, context);
            }
            if (sqlNode.getSortClause() != null) {
                sqlNode.getSortClause().unParse(writer, context);
            }
        }
        writer.append(") ");
    }

    private boolean funcConvertWithOutPara(FuncApplication sqlNode, SqlWriter writer) {
        if ("regexp_count".equalsIgnoreCase(sqlNode.getFuncName())) {
            this.regexpCountProcess(sqlNode, writer);
            return false;
        }
        return true;
    }

    private void funcConvertWithPara(FuncApplication sqlNode, SqlWriter writer) {
        this.timeFuncConvert(sqlNode);
        this.strFuncConvert(sqlNode);
        this.mathFuncConvert(sqlNode);
        this.otherFuncConvert(sqlNode);
    }

    private void mathFuncConvert(FuncApplication sqlNode) {
        if ("dceils".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("CEILING");
        }
        if ("dfloor".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("FLOOR");
        }
        if ("pow".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("POWER");
        }
        if ("numeric_sqrt".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("SQRT");
        }
    }

    private void otherFuncConvert(FuncApplication sqlNode) {
        if ("current_db".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("CURRENT_DATABASE");
        }
    }

    private void strFuncConvert(FuncApplication sqlNode) {
        if ("LEN".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("LENGTH");
        }
        if ("charindex".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("position");
        }
        if ("ISNULL".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("IFNULL");
        }
        if ("isnumeric".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("regexp_like");
            if (sqlNode.getFuncArgList() != null) {
                FuncArgExpr funcArgExpr = null;
                try {
                    funcArgExpr = sqlNode.getFuncArgList().getNodes().get(0).deepClone();
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "function clone error,please check the args,function name: isnumeric");
                }
                funcArgExpr.getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprIndirection().setColIdOrParam("'^[0-9\\.]+$'");
                funcArgExpr.getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprIndirection().setIndirection(null);
                sqlNode.getFuncArgList().addNode(funcArgExpr);
            }
        }
        if ("nvl2".equalsIgnoreCase(sqlNode.getFuncName())) {
            List<FuncArgExpr> nodes = sqlNode.getFuncArgList().getNodes();
            SqlNodeList<FuncArgExpr> funcArgList = new SqlNodeList<FuncArgExpr>();
            funcArgList.addNode(nodes.get(0));
            funcArgList.addNode(this.GetTypeOneFuncArgExpr("NULL"));
            funcArgList.addNode(nodes.get(2));
            funcArgList.addNode(nodes.get(1));
            sqlNode.setFuncArgList(funcArgList);
            sqlNode.setFuncName("DECODE");
        }
        if ("unichr".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("CHR");
        }
        if ("unicode".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("ASCII");
        }
        if ("hex_to_binary".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("HEXTORAW");
        }
    }

    private FuncArgExpr GetTypeOneFuncArgExpr(String value) {
        FuncArgExpr funcArgExpr = new FuncArgExpr();
        ExprConst exprConst = new ExprConst();
        exprConst.setConstValue(value);
        ExprCon exprCon = new ExprCon();
        exprCon.setExprConst(exprConst);
        Expr expr = new Expr();
        expr.setExprCon(exprCon);
        ExprCaret exprCaret = new ExprCaret();
        exprCaret.setExpr(expr);
        ExprCompare exprCompare = new ExprCompare();
        exprCompare.setExprCaret(exprCaret);
        ExprIsNot exprIsNot = new ExprIsNot();
        exprIsNot.setExprCompare(exprCompare);
        Expression expression = new Expression();
        expression.setExprIsNot(exprIsNot);
        funcArgExpr.setExpression(expression);
        return funcArgExpr;
    }

    private void timeFuncConvert(FuncApplication sqlNode) {
        if ("GETDATE".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("SYSDATE");
        }
        if ("convert_timezone".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("timezone");
        }
        if ("pgdate_part".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("date_part");
        }
        if ("date_diff".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("timestampdiff");
            this.timestampdiffProcess(sqlNode);
        }
        if ("DATEADD".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("ADDDATE");
            this.dateaddProcess(sqlNode);
        }
        if ("DATE_ADD".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("ADDDATE");
            this.dateaddSetInterval(sqlNode);
        }
        if ("TO_DATE".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("date_format");
            this.dateFormatProcess(sqlNode);
        }
        if ("month_between".equalsIgnoreCase(sqlNode.getFuncName())) {
            this.monthBetweenConvert(sqlNode);
        } else if ("end_of_months".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("LAST_DAY");
        } else if ("first_of_months".equalsIgnoreCase(sqlNode.getFuncName())) {
            sqlNode.setFuncName("DATE_TRUNC");
            SqlNodeList<FuncArgExpr> funcArgList = new SqlNodeList<FuncArgExpr>();
            funcArgList.addNode(this.GetTypeOneFuncArgExpr("'month'"));
            funcArgList.getNodes().addAll(sqlNode.getFuncArgList().getNodes());
            sqlNode.setFuncArgList(funcArgList);
        }
    }

    private void monthBetweenConvert(FuncApplication sqlNode) {
        sqlNode.setFuncName("DATE_PART");
        FuncApplication funcApplication = new FuncApplication();
        funcApplication.setFuncName("AGE");
        List<FuncArgExpr> nodes = sqlNode.getFuncArgList().getNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            DataTypeBase dataTypeBase = new DataTypeBase();
            dataTypeBase.setDataType("TIMESTAMP");
            nodes.get(i).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon().getExprConst().setDataTypeBase(dataTypeBase);
        }
        SqlNodeList<FuncArgExpr> funcArgExprSqlNodeList = new SqlNodeList<FuncArgExpr>();
        try {
            FuncArgExpr arg1 = nodes.get(0).deepClone();
            FuncArgExpr arg2 = nodes.get(1).deepClone();
            funcArgExprSqlNodeList.addNode(arg1);
            funcArgExprSqlNodeList.addNode(arg2);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "function clone error,please check the args,function name: month_between");
        }
        funcApplication.setFuncArgList(funcArgExprSqlNodeList);
        SqlNodeList<FuncArgExpr> datePartArgList = new SqlNodeList<FuncArgExpr>();
        datePartArgList.addNode(this.GetTypeOneFuncArgExpr("'month'"));
        datePartArgList.addNode(this.GetTypeTwoFuncArgExpr(funcApplication));
        sqlNode.setFuncArgList(datePartArgList);
    }

    private FuncArgExpr GetTypeTwoFuncArgExpr(FuncApplication sqlNode) {
        FuncArgExpr funcArgExpr = new FuncArgExpr();
        ExprFunc exprFunc = new ExprFunc();
        exprFunc.setFuncApplication(sqlNode);
        Expr expr = new Expr();
        expr.setExprFunc(exprFunc);
        ExprCaret exprCaret = new ExprCaret();
        exprCaret.setExpr(expr);
        ExprCompare exprCompare = new ExprCompare();
        exprCompare.setExprCaret(exprCaret);
        ExprIsNot exprIsNot = new ExprIsNot();
        exprIsNot.setExprCompare(exprCompare);
        Expression expression = new Expression();
        expression.setExprIsNot(exprIsNot);
        funcArgExpr.setExpression(expression);
        return funcArgExpr;
    }

    private void timestampdiffProcess(FuncApplication sqlNode) {
        if (sqlNode.getFuncArgList() != null) {
            SqlNodeList<FuncArgExpr> funcArgExprSqlNodeList = new SqlNodeList<FuncArgExpr>();
            SqlNodeList<FuncArgExpr> funcArgExprList = sqlNode.getFuncArgList();
            for (int i = 0; i < funcArgExprList.getNodes().size(); ++i) {
                if (i == 0) {
                    String constant = funcArgExprList.getNodes().get(i).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon().getExprConst().getConstValue();
                    constant = constant.endsWith("s'") ? constant.substring(1, constant.length() - 2) : constant;
                    funcArgExprList.getNodes().get(i).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon().getExprConst().setConstValue(constant);
                }
                funcArgExprSqlNodeList.addNode(funcArgExprList.getNodes().get(i));
            }
            sqlNode.setFuncArgList(funcArgExprSqlNodeList);
        }
    }

    private void dateaddProcess(FuncApplication sqlNode) {
        if (sqlNode.getFuncArgList() != null) {
            SqlNodeList<FuncArgExpr> funcArgExprSqlNodeList = new SqlNodeList<FuncArgExpr>();
            SqlNodeList<FuncArgExpr> funcArgExprList = sqlNode.getFuncArgList();
            for (int i = funcArgExprList.getNodes().size() - 1; i > 0; --i) {
                funcArgExprSqlNodeList.addNode(funcArgExprList.getNodes().get(i));
            }
            sqlNode.setFuncArgList(funcArgExprSqlNodeList);
        }
    }

    private void dateaddSetInterval(FuncApplication sqlNode) {
        if (sqlNode.getFuncArgList() != null) {
            Expr expr;
            SqlNodeList<FuncArgExpr> funcArgExprSqlNodeList = new SqlNodeList<FuncArgExpr>();
            SqlNodeList<FuncArgExpr> funcArgExprList = sqlNode.getFuncArgList();
            if (funcArgExprList.getNodes().get(0).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon() != null) {
                String stringConstant = funcArgExprList.getNodes().get(0).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon().getExprConst().getConstValue().split("'")[1];
                funcArgExprList.getNodes().get(0).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon().getExprConst().setConstValue(stringConstant);
            }
            if ((expr = funcArgExprList.getNodes().get(1).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr()).getExprCon() == null) {
                return;
            }
            String constValue = "interval '" + expr.getExprCon().getExprConst().getConstValue() + "'";
            expr.getExprCon().getExprConst().setConstValue(constValue);
            for (int i = funcArgExprList.getNodes().size() - 1; i >= 0; --i) {
                funcArgExprSqlNodeList.addNode(funcArgExprList.getNodes().get(i));
            }
            sqlNode.setFuncArgList(funcArgExprSqlNodeList);
        }
    }

    private void regexpCountProcess(FuncApplication sqlNode, SqlWriter writer) {
        if (sqlNode.getFuncArgList() != null) {
            SqlNodeList<FuncArgExpr> funcArgExprList = sqlNode.getFuncArgList();
            String sourceString = funcArgExprList.getNodes().get(0).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprIndirection().getColIdOrParam();
            String pattern = funcArgExprList.getNodes().get(1).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon().getExprConst().getConstValue();
            writer.append("(length(").append(sourceString).append(") ").append("-");
            writer.append("length(").append("replace(").append(sourceString).append(", ").append(pattern).append(", ").append("''").append("))");
            writer.append("/(length(").append(pattern).append("))) ");
        }
    }

    private void dateFormatProcess(FuncApplication sqlNode) {
        if (sqlNode.getFuncArgList() != null) {
            SqlNodeList<FuncArgExpr> funcArgExprSqlNodeList = new SqlNodeList<FuncArgExpr>();
            SqlNodeList<FuncArgExpr> funcArgExprList = sqlNode.getFuncArgList();
            for (int i = 0; i < funcArgExprList.getNodes().size(); ++i) {
                ExprCon exprCon;
                if (i == 1 && (exprCon = funcArgExprList.getNodes().get(i).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon()) != null) {
                    String constant = exprCon.getExprConst().getConstValue();
                    if (constant.trim().equalsIgnoreCase("'YYYY-MM-DD'")) {
                        constant = "'%Y-%m-%d'";
                    } else if (constant.trim().equalsIgnoreCase("'YYYYMMDD'")) {
                        constant = "'%Y%m%d'";
                    }
                    funcArgExprList.getNodes().get(i).getExpression().getExprIsNot().getExprCompare().getExprCaret().getExpr().getExprCon().getExprConst().setConstValue(constant);
                }
                funcArgExprSqlNodeList.addNode(funcArgExprList.getNodes().get(i));
            }
            sqlNode.setFuncArgList(funcArgExprSqlNodeList);
        }
    }
}

