/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.FuncOptItem;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=FuncOptItem.class)
public class FuncOptItemUnParser
implements UnParser<FuncOptItem> {
    @Override
    public void unParse(FuncOptItem sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getLanguage() != null) {
            writer.append("LANGUAGE ");
            if (sqlNode.getLanguage().equalsIgnoreCase("NZPLSQL")) {
                writer.append("plpgsql");
            } else {
                writer.append(sqlNode.getLanguage());
            }
            writer.newLine();
        } else if (sqlNode.getSimpleOpt() != null) {
            String trim = sqlNode.getSimpleOpt().trim();
            if (trim.equalsIgnoreCase("EXECUTE AS CALLER")) {
                return;
            }
            if (trim.equalsIgnoreCase("NO SQL") || trim.equalsIgnoreCase("CONTAINS SQL")) {
                return;
            }
            writer.append(sqlNode.getSimpleOpt()).newLine();
        } else if (sqlNode.getPlsqlBody() != null) {
            sqlNode.getPlsqlBody().unParse(writer, context);
            writer.newLine();
        } else if (sqlNode.getDef() != null) {
            writer.append("AS").writeSpace().append(sqlNode.getDef()).newLine();
        } else if (sqlNode.getObjFile() != null) {
            writer.append("AS").writeSpace();
            writer.append(sqlNode.getObjFile()).append(",").append(sqlNode.getLinKSymbol()).newLine();
        } else if (sqlNode.getFunctionSqlBody() != null) {
            sqlNode.getFunctionSqlBody().unParse(writer, context);
        }
    }
}

