/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.IndexElem;
import com.huawei.hwclouds.migration.pg.nodes.IndexStmt;
import com.huawei.hwclouds.migration.pg.nodes.RelOptionElem;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.List;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=IndexStmt.class)
public class IndexStmtUnParser
implements UnParser<IndexStmt> {
    @Override
    public void unParse(IndexStmt sqlNode, SqlWriter writer, UnParserContext context) {
        int i;
        writer.append("CREATE ");
        if (sqlNode.isUniqueIndex()) {
            writer.append("UNIQUE ");
        }
        writer.append("INDEX ");
        if (sqlNode.isExistConcurrently()) {
            writer.append("CONCURRENTLY ");
        }
        if (sqlNode.isIfNotExist()) {
            writer.append("IF NOT EXISTS ");
        }
        writer.append(sqlNode.getIndexName()).writeSpace().append("ON ");
        sqlNode.getRelationExpr().unParse(writer, context);
        if (sqlNode.getAccessMethodClause() != null) {
            writer.append(sqlNode.getAccessMethodClause()).writeSpace();
        }
        writer.append("( ");
        List<IndexElem> nodesForParams = sqlNode.getIndexParams().getNodes();
        for (int i2 = 0; i2 < nodesForParams.size(); ++i2) {
            nodesForParams.get(i2).unParse(writer, context);
            if (i2 == nodesForParams.size() - 1) continue;
            writer.append(", ");
        }
        writer.append(") ");
        if (sqlNode.getOptInclude() != null) {
            writer.append("INCLUDE ");
            writer.append("( ");
            List<IndexElem> nodesForInclude = sqlNode.getOptInclude().getIndexElemSqlNodeList().getNodes();
            for (i = 0; i < nodesForInclude.size(); ++i) {
                nodesForInclude.get(i).unParse(writer, context);
                if (i == nodesForInclude.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
        if (sqlNode.getRelOptions() != null) {
            writer.append("WITH ");
            writer.append("( ");
            List<RelOptionElem> nodesForRelElem = sqlNode.getRelOptions().getRelOptionElemSqlNodeList().getNodes();
            for (i = 0; i < nodesForRelElem.size(); ++i) {
                nodesForRelElem.get(i).unParse(writer, context);
                if (i == nodesForRelElem.size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
        if (sqlNode.getOptTablespace() != null) {
            writer.append(sqlNode.getOptTablespace()).writeSpace();
        }
        if (sqlNode.getWhereClause() != null) {
            writer.append("WHERE ");
            sqlNode.getWhereClause().unParse(writer, context);
        }
    }
}

