/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.JoinClause;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=JoinClause.class)
public class JoinClauseUnParser
implements UnParser<JoinClause> {
    @Override
    public void unParse(JoinClause sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isCrossJoin()) {
            writer.append("CROSS").writeSpace();
        }
        if (sqlNode.isNatural()) {
            writer.append("NATURAL").writeSpace();
        }
        if (sqlNode.getJoinType() != null) {
            writer.append(sqlNode.getJoinType()).writeSpace();
        }
        writer.append("JOIN").writeSpace();
        sqlNode.getTableRef().unParse(writer, context);
        if (sqlNode.getExpression() != null) {
            writer.writeSpace().append("ON").writeSpace();
            sqlNode.getExpression().unParse(writer, context);
        }
        if (sqlNode.getNameList() != null) {
            writer.writeSpace().append("USING").writeSpace().append("(");
            int size = sqlNode.getNameList().size();
            for (int i = 0; i < size; ++i) {
                writer.append(sqlNode.getNameList().get(i));
                if (i == size - 1) continue;
                writer.append(",");
            }
        }
    }
}

