/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.MigrationContextUtil;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.PartitionElement;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=PartitionElement.class)
public class PartitionElementUnParser
implements UnParser<PartitionElement> {
    private static final Logger LOGGER = LogManager.getLogger(PartitionElementUnParser.class);

    @Override
    public void unParse(PartitionElement sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getSubPartitionElementList() != null && !sqlNode.getSubPartitionElementList().isEmpty()) {
            this.unParseSubPartitionElement(sqlNode, writer, context);
            return;
        }
        if (sqlNode.isDefaultPartition()) {
            writer.append("DEFAULT").writeSpace();
        }
        writer.append("PARTITION").writeSpace().append(sqlNode.getPartitionName());
        if (sqlNode.getValuesExprList() != null && !sqlNode.getValuesExprList().isEmpty()) {
            writer.writeSpace();
            writer.append("VALUES").writeSpace().append("(");
            sqlNode.getValuesExprList().unParse(writer, context);
            writer.append(")");
        }
        if (sqlNode.getPartitionStartExpr() != null) {
            writer.writeSpace();
            writer.append("START").writeSpace().append("(");
            sqlNode.getPartitionStartExpr().unParse(writer, context);
            writer.append(")");
        }
        if (sqlNode.getPartitionEndExpr() != null) {
            writer.writeSpace();
            Map<String, String> placeHolderMap = MigrationContextUtil.getPlaceHolderMap();
            int index = placeHolderMap.size();
            writer.append(":" + index);
            placeHolderMap.put(String.valueOf(index), "END");
            writer.writeSpace().append("(");
            if ("INCLUSIVE".equalsIgnoreCase(sqlNode.getEndRangeParam())) {
                SqlWriter endValueWriter = writer.cloneEmpty();
                sqlNode.getPartitionEndExpr().unParse(endValueWriter, context);
                String endValue = endValueWriter.toSqlString().getSql();
                CharSequence[] split = endValue.split("::");
                try {
                    String value = split[0].trim();
                    if (value.startsWith("'") && value.endsWith("'")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        Date endDate = sdf.parse(value.substring(1, value.length() - 1));
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(endDate);
                        calendar.add(5, 1);
                        split[0] = "'" + sdf.format(calendar.getTime()) + "'";
                    } else {
                        try {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                            Date endDate = sdf.parse(value);
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(endDate);
                            calendar.add(5, 1);
                            split[0] = sdf.format(calendar.getTime());
                        }
                        catch (Exception e) {
                            split[0] = String.valueOf(Long.parseLong(value) + 1L);
                        }
                    }
                    writer.append(String.join((CharSequence)"::", split));
                }
                catch (Exception e) {
                    LOGGER.error("handle partition end param INCLUSIVE error,ignore INCLUSIVE", (Throwable)e);
                    sqlNode.getPartitionEndExpr().unParse(writer, context);
                }
            } else {
                sqlNode.getPartitionEndExpr().unParse(writer, context);
            }
            writer.append(")");
        }
        if (sqlNode.getPartitionEveryExpr() != null) {
            writer.writeSpace();
            writer.append("EVERY").writeSpace().append("(");
            sqlNode.getPartitionEveryExpr().unParse(writer, context);
            writer.append(")");
        }
    }

    private void unParseSubPartitionElement(PartitionElement sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getValuesExprList() == null || sqlNode.getValuesExprList().isEmpty()) {
            throw new ParserRuntimeException(ParserExceptionDef.SQL_PARSER_EXCEPTION, "PARTITION must have VALUES when have sub-partition.");
        }
        for (int i = 0; i < sqlNode.getSubPartitionElementList().getNodes().size(); ++i) {
            PartitionElement subpartitionElement = sqlNode.getSubPartitionElementList().getNodes().get(i);
            writer.append("PARTITION").writeSpace();
            writer.append(sqlNode.getPartitionName()).append("_").append(subpartitionElement.getPartitionName()).writeSpace();
            if (subpartitionElement.getValuesExprList() != null && !subpartitionElement.getValuesExprList().isEmpty()) {
                writer.append("VALUES").writeSpace().append("(");
                sqlNode.getValuesExprList().unParse(writer, context);
                writer.append(",");
                subpartitionElement.getValuesExprList().unParse(writer, context);
                writer.append(")");
            } else if (subpartitionElement.getPartitionEndExpr() != null) {
                writer.append("VALUES LESS THAN").writeSpace().append("(");
                sqlNode.getValuesExprList().unParse(writer, context);
                writer.append(",");
                subpartitionElement.getPartitionEndExpr().unParse(writer, context);
                writer.append(")");
            } else if (subpartitionElement.getLessThanExprList() != null && !subpartitionElement.getLessThanExprList().isEmpty()) {
                writer.append("VALUES LESS THAN").writeSpace().append("(");
                sqlNode.getValuesExprList().unParse(writer, context);
                writer.append(",");
                subpartitionElement.getLessThanExprList().unParse(writer, context);
                writer.append(")");
            }
            if (i == sqlNode.getSubPartitionElementList().getNodes().size() - 1) continue;
            writer.append(",");
        }
    }
}

