/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.PartitionElement;
import com.huawei.hwclouds.migration.pg.nodes.PartitionKey;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=PartitionKey.class)
public class PartitionKeyUnParser
implements UnParser<PartitionKey> {
    @Override
    public void unParse(PartitionKey sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("PARTITION BY").writeSpace();
        if (sqlNode.getSubPartitionType() != null) {
            writer.append(sqlNode.getSubPartitionType()).append("(");
            writer.append(sqlNode.getColId()).append(",").append(sqlNode.getSubColId());
            writer.append(")").writeSpace();
            this.orderPartitionElementList(sqlNode);
        } else {
            writer.append(sqlNode.getPartitionType());
            writer.append("(").append(sqlNode.getColId()).append(")").writeSpace();
        }
        if (sqlNode.getPartitionElementList() != null && !sqlNode.getPartitionElementList().isEmpty()) {
            writer.append("(");
            List partitionElementList = sqlNode.getPartitionElementList().getNodes().stream().filter(partitionelement -> !partitionelement.isDefaultPartition()).collect(Collectors.toList());
            sqlNode.getPartitionElementList().setNodes(partitionElementList);
            sqlNode.getPartitionElementList().unParse(writer, context);
            writer.append(")");
        }
    }

    private void orderPartitionElementList(PartitionKey sqlNode) {
        if (sqlNode.getPartitionElementList() == null || sqlNode.getPartitionElementList().isEmpty()) {
            return;
        }
        List<PartitionElement> partitionElementList = sqlNode.getPartitionElementList().getNodes();
        partitionElementList.sort(Comparator.comparing(PartitionElement::getValuesExprListStr));
    }
}

