/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.PrivilegeClause;
import com.huawei.hwclouds.migration.pg.nodes.RevokeStmt;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=RevokeStmt.class)
public class RevokeStmtUnParser
implements UnParser<RevokeStmt> {
    @Override
    public void unParse(RevokeStmt sqlNode, SqlWriter writer, UnParserContext context) {
        writer.append("REVOKE").writeSpace();
        if (sqlNode.isGrant()) {
            writer.append("GRANT OPTION FOR").writeSpace();
        }
        if (sqlNode.getPrivileges() == null || sqlNode.getPrivileges().isEmpty()) {
            throw new ParserRuntimeException(ParserExceptionDef.NON_COMPLIANT_STATEMENT, "revoke privileges must be not null.");
        }
        for (int i = 0; i < sqlNode.getPrivileges().size(); ++i) {
            PrivilegeClause revokePrivilege = sqlNode.getPrivileges().get(i);
            writer.append(revokePrivilege.getPrivilege());
            if (revokePrivilege.getColumnList() != null && !revokePrivilege.getColumnList().isEmpty()) {
                writer.writeSpace().append("(");
                writer.append(String.join((CharSequence)",", revokePrivilege.getColumnList()));
                writer.append(")");
            }
            if (i == sqlNode.getPrivileges().size() - 1) continue;
            writer.append(",");
        }
        writer.writeSpace().append("ON").writeSpace();
        writer.append(sqlNode.getPrivilegeTarget()).writeSpace();
        if (sqlNode.getTargetNameList() != null && !sqlNode.getTargetNameList().isEmpty()) {
            writer.append(String.join((CharSequence)",", sqlNode.getTargetNameList())).writeSpace();
        } else if (sqlNode.getTargetFunctionList() != null && !sqlNode.getTargetFunctionList().isEmpty()) {
            sqlNode.getTargetFunctionList().unParse(writer, context);
        }
        writer.append("FROM").writeSpace();
        writer.append(String.join((CharSequence)",", sqlNode.getGranteeList()));
        if (sqlNode.getOptDropBehavior() != null) {
            writer.writeSpace().append(sqlNode.getOptDropBehavior());
        }
    }
}

