/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.LimitClause;
import com.huawei.hwclouds.migration.pg.nodes.OffsetClause;
import com.huawei.hwclouds.migration.pg.nodes.SelectLimit;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SelectLimit.class)
public class SelectLimitUnParser
implements UnParser<SelectLimit> {
    @Override
    public void unParse(SelectLimit sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.isLimitInFront()) {
            this.uunParseLimitClause(sqlNode, writer, context);
        }
        this.uunParseOffsetClause(sqlNode, writer, context);
        if (!sqlNode.isLimitInFront()) {
            this.uunParseLimitClause(sqlNode, writer, context);
        }
    }

    private void uunParseLimitClause(SelectLimit sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getLimitClause() == null) {
            return;
        }
        LimitClause limitClause = sqlNode.getLimitClause();
        writer.append("LIMIT ");
        limitClause.getSelectLimitValue().unParse(writer, context);
        if (limitClause.getSelectOffsetValue() != null) {
            writer.append(", ");
            limitClause.getSelectOffsetValue().unParse(writer, context);
        }
    }

    private void uunParseOffsetClause(SelectLimit sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getOffsetClause() == null) {
            return;
        }
        OffsetClause offsetClause = sqlNode.getOffsetClause();
        writer.append("OFFSET").writeSpace();
        if (offsetClause.getSelectOffsetValue() != null) {
            offsetClause.getSelectOffsetValue().unParse(writer, context);
        } else if (offsetClause.getSelectFetchFirstValue() != null) {
            offsetClause.getSelectFetchFirstValue().unParse(writer, context);
        } else if (offsetClause.getSelectFetchFirstValuePlus() != null) {
            writer.append("+").append(offsetClause.getSelectFetchFirstValuePlus());
        } else if (offsetClause.getSelectFetchFirstValueMinus() != null) {
            writer.append("-").append(offsetClause.getSelectFetchFirstValueMinus());
        }
        if (offsetClause.getRowOrRows() != null) {
            writer.writeSpace().append(offsetClause.getRowOrRows());
        }
    }
}

