/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.unparser;

import com.huawei.hwclouds.migration.pg.UnParser;
import com.huawei.hwclouds.migration.pg.UnParserAnnotation;
import com.huawei.hwclouds.migration.pg.UnParserContext;
import com.huawei.hwclouds.migration.pg.nodes.BitType;
import com.huawei.hwclouds.migration.pg.nodes.CharacterType;
import com.huawei.hwclouds.migration.pg.nodes.GenericType;
import com.huawei.hwclouds.migration.pg.nodes.IntervalType;
import com.huawei.hwclouds.migration.pg.nodes.NumericType;
import com.huawei.hwclouds.migration.pg.nodes.OtherType;
import com.huawei.hwclouds.migration.pg.nodes.SimpleTypeName;
import com.huawei.hwclouds.migration.pg.nodes.SqlTypeName;
import com.huawei.hwclouds.migration.pg.nodes.TimeType;
import com.huawei.hwclouds.migration.pg.util.ConfigUtil;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.Locale;

@UnParserAnnotation(dialect=SqlDialect.DWS, sqlNode=SimpleTypeName.class)
public class SimpleTypeNameUnParser
implements UnParser<SimpleTypeName> {
    @Override
    public void unParse(SimpleTypeName sqlNode, SqlWriter writer, UnParserContext context) {
        if (sqlNode.getGenerictype() != null) {
            this.dealWithGenericType(sqlNode.getGenerictype(), writer, context);
        } else if (sqlNode.getNumericType() != null) {
            this.dealWithNumericType(sqlNode.getNumericType(), writer, context);
        } else if (sqlNode.getBitType() != null) {
            this.dealWithBitType(sqlNode.getBitType(), writer, context);
        } else if (sqlNode.getCharacterType() != null) {
            this.dealWithCharacterType(sqlNode.getCharacterType(), writer);
        } else if (sqlNode.getIntervalType() != null) {
            this.dealWithIntervalType(sqlNode.getIntervalType(), writer);
        } else if (sqlNode.getTimeType() != null) {
            this.dealWithTimeType(sqlNode.getTimeType(), writer);
        } else if (sqlNode.getOtherType() != null) {
            this.dealWithOtherType(sqlNode.getOtherType(), writer);
        }
    }

    private void dealWithOtherType(OtherType otherType, SqlWriter writer) {
        switch (otherType.getTypeName().toLowerCase(Locale.ROOT)) {
            case "rowid": {
                writer.append("TID ");
                break;
            }
            case "transaction id": {
                writer.append("XID ");
                break;
            }
            case "record": {
                writer.append("RECORD ");
                break;
            }
            case "money": {
                writer.append("MONEY ");
                break;
            }
            case "inet": {
                writer.append("INET ");
                break;
            }
            case "oid": {
                writer.append("OID ");
                break;
            }
            case "json": {
                writer.append("JSON ");
                break;
            }
            case "jsonb": {
                writer.append("JSONB ");
                break;
            }
            case "unknown": {
                writer.append("TEXT ");
                break;
            }
            default: {
                writer.append(otherType.getTypeName()).writeSpace();
            }
        }
    }

    private void dealWithGenericType(GenericType generictype, SqlWriter writer, UnParserContext context) {
        writer.append(generictype.getName()).writeSpace();
        writer.append("( ");
        for (int i = 0; i < generictype.getOptTypeModifiers().getNodes().size(); ++i) {
            generictype.getOptTypeModifiers().getNodes().get(i).unParse(writer, context);
            if (i == generictype.getOptTypeModifiers().getNodes().size() - 1) continue;
            writer.append(", ");
        }
        writer.append(") ");
    }

    private void dealWithNumericType(NumericType numericType, SqlWriter writer, UnParserContext context) {
        if (numericType.getNumeric().getName().equalsIgnoreCase("BIGINT IDENTITY")) {
            writer.append("BIGSERIAL").writeSpace();
        } else if (numericType.getNumeric().getName().equalsIgnoreCase("INT IDENTITY")) {
            writer.append("SERIAL").writeSpace();
        } else {
            writer.append(numericType.getNumeric().getName()).writeSpace();
        }
        if (numericType.getOptTypeModifiers() != null) {
            writer.append("( ");
            for (int i = 0; i < numericType.getOptTypeModifiers().getNodes().size(); ++i) {
                numericType.getOptTypeModifiers().getNodes().get(i).unParse(writer, context);
                if (i == numericType.getOptTypeModifiers().getNodes().size() - 1) continue;
                writer.append(", ");
            }
            writer.append(") ");
        }
    }

    private void dealWithBitType(BitType bitType, SqlWriter writer, UnParserContext context) {
        switch (bitType.getTypeName().toLowerCase(Locale.ROOT)) {
            case "bit": {
                writer.append("BIT");
                if (bitType.isExistVarying()) {
                    writer.writeSpace().append("VARYING ");
                }
                if (bitType.getIConst() == null) break;
                writer.append("( ");
                writer.append(bitType.getIConst()).append(") ");
                break;
            }
            case "byteint": {
                writer.append("INT ");
                break;
            }
            case "varbinary": 
            case "bytea": {
                writer.append("BYTEA ");
                break;
            }
        }
    }

    private void dealWithCharacterType(CharacterType characterType, SqlWriter writer) {
        writer.append(characterType.getCharacterName().getName()).writeSpace();
        if (characterType.getIConst() != null) {
            if (characterType.getCharacterName() == SqlTypeName.VARCHAR || characterType.getCharacterName() == SqlTypeName.CHARACTERVARYING) {
                String coefficientStr = ConfigUtil.getConfigValue(writer.getConfig("param.config.flag"), "table.output.varchar.coefficient", "1");
                int coefficient = coefficientStr == null ? 1 : Integer.parseInt(coefficientStr);
                int iConst = Integer.parseInt(characterType.getIConst());
                writer.append("(").append(String.valueOf(coefficient * iConst)).append(") ");
            } else {
                writer.append("( ").append(characterType.getIConst()).writeSpace().append(") ");
            }
        }
    }

    private void dealWithIntervalType(IntervalType intervalType, SqlWriter writer) {
        writer.append("INTERVAL ");
        if (intervalType.getOptInterval() != null) {
            writer.append(intervalType.getOptInterval()).writeSpace();
        } else if (intervalType.getIConst() != null) {
            writer.append("( ").append(intervalType.getIConst()).writeSpace().append(") ");
        }
    }

    private void dealWithTimeType(TimeType timeType, SqlWriter writer) {
        if (timeType.getTypeName().getName().equalsIgnoreCase("datetime")) {
            timeType.setTypeName(SqlTypeName.TIMESTAMPWITHOUTTIMEZONE);
        }
        writer.append(timeType.getTypeName().getName()).writeSpace();
        if (timeType.getIConst() != null) {
            writer.append("( ").append(timeType.getIConst()).writeSpace().append(") ");
        }
        if (timeType.getTimeZone() != null) {
            writer.append(timeType.getTimeZone()).writeSpace();
        }
    }
}

