/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.util;

import com.huawei.hwclouds.migration.common.util.QuoteUtils;
import com.huawei.hwclouds.migration.pg.nodes.CreateStmt;
import com.huawei.hwclouds.migration.pg.nodes.TableConstraint;
import com.huawei.hwclouds.migration.pg.nodes.TableElement;
import com.huawei.hwclouds.migration.pg.writer.SqlWriter;
import java.util.List;
import java.util.Locale;

public class CreateIndexUtil {
    public static String getIndexName(CreateStmt createStmt, TableElement tableElement) {
        String fullTName = createStmt.getTableName();
        int dbNameIndex = fullTName.lastIndexOf(".");
        String idxPrefix = "IDX_";
        String tName = dbNameIndex > 0 ? QuoteUtils.removeDoubleQuote(fullTName.substring(dbNameIndex + 1)) : fullTName;
        String idxColumns = tableElement.getColumnDef().getColId();
        String idxName = idxPrefix + tName + "_" + idxColumns;
        if (idxName.length() > 63) {
            idxName = idxName.substring(0, 63);
        }
        return idxName.toLowerCase(Locale.ROOT);
    }

    public static String getIndexNameConstraint(TableConstraint tableConstraint, SqlWriter writer) {
        String idxName;
        SqlWriter nWriter = writer.cloneEmpty();
        String fullTName = nWriter.toSqlString().getSql();
        int dbNameIndex = fullTName.lastIndexOf(".");
        String idxPrefix = "IDX_";
        String tName = dbNameIndex > 0 ? QuoteUtils.removeDoubleQuote(fullTName.substring(dbNameIndex + 1)) : fullTName;
        String idxColumns = "";
        if (tableConstraint.getConstraintElem().getUkOrPkTableConstraint() != null) {
            List<String> columnList = tableConstraint.getConstraintElem().getUkOrPkTableConstraint().getColumnList();
            for (int i = 0; i < columnList.size(); ++i) {
                idxColumns = idxColumns + columnList.get(i);
                if (i == columnList.size() - 1) continue;
                idxColumns = idxColumns + "_";
            }
        }
        if ((idxName = idxPrefix + tName + "_" + idxColumns).length() > 63) {
            idxName = idxName.substring(0, 63);
        }
        return idxName.toLowerCase(Locale.ROOT);
    }
}

