/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.pg.util;

import com.google.common.collect.Lists;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.pg.util.SqlDialect;
import java.util.List;

public class SqlString
implements ISqlString {
    private final String str;
    private SqlDialect dialect;
    private static final List<String> commentAffixList = Lists.newArrayList((Object[])new String[]{"#", "--", "*", "/*", "*/", "\\echo"});

    public SqlString(SqlDialect dialect, String str) {
        this.dialect = dialect;
        this.str = str;
        assert (str != null);
        assert (dialect != null);
    }

    public String toString() {
        return this.str;
    }

    public String getSql() {
        return this.str;
    }

    public SqlDialect getDialect() {
        return this.dialect;
    }

    public static boolean isSqlComment(String sql) {
        String oirStr = sql.trim();
        for (String affix : commentAffixList) {
            if (!oirStr.startsWith(affix)) continue;
            return true;
        }
        return false;
    }

    public static String handleErrorRes(String res) {
        return res;
    }
}

