/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migrationwrapper;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.github.vertical_blank.sqlformatter.languages.Dialect;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.common.entity.PlaceHolderParam;
import com.huawei.hwclouds.migration.common.exception.ParserExceptionDef;
import com.huawei.hwclouds.migration.common.exception.ParserRuntimeException;
import com.huawei.hwclouds.migration.common.util.MigrationContextUtil;
import com.huawei.hwclouds.migration.hive.HiveConvertor;
import com.huawei.hwclouds.migration.hive.config.HivePropertyLoader;
import com.huawei.hwclouds.migration.oracle.OracleConvertor;
import com.huawei.hwclouds.migration.oracle.config.OraclePropertyLoader;
import com.huawei.hwclouds.migration.pg.PgConvertor;
import com.huawei.hwclouds.migration.pg.config.PgPropertyLoader;
import com.huawei.hwclouds.scs.dws.DWSMigration;
import com.huawei.hwclouds.scs.dws.FileResObject;
import com.huawei.hwclouds.scs.dws.FileResult;
import com.huawei.hwclouds.scs.dws.MysqlConvertor;
import com.huawei.hwclouds.scs.dws.ResultProcessor;
import com.huawei.hwclouds.scs.dws.SingleResObject;
import com.huawei.hwclouds.scs.sql.config.MySqlPropertyLoader;
import com.huawei.hwclouds.scs.sql.util.SqlString;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;

public class ConvertorEntrance {
    public static void convertFiles(String oriDataBase, Map<String, String> configProperties, Map<String, File> fileList, ResultProcessor fileObject) throws ParserException {
        double presentRes = 0.0;
        int fileCount = fileList.size();
        String taskStatus = "SUCCESS";
        try {
            Object convertor = null;
            switch (oriDataBase) {
                case "adb": 
                case "mysql": 
                case "bigquery": {
                    MySqlPropertyLoader.loadPropertyMap(configProperties);
                    convertor = new MysqlConvertor(null);
                    break;
                }
                case "oracle": {
                    OraclePropertyLoader.loadPropertyMap(configProperties);
                    convertor = new OracleConvertor(null);
                    break;
                }
                case "hologres": 
                case "redshift": {
                    PgPropertyLoader.loadPropertyMap(configProperties);
                    convertor = new PgConvertor(null);
                    break;
                }
                case "hive": {
                    HivePropertyLoader.loadPropertyMap(configProperties);
                    convertor = new HiveConvertor(null);
                    break;
                }
                default: {
                    throw new ParserException("Not Support Ori DataBase");
                }
            }
            for (String fileId : fileList.keySet()) {
                try {
                    String status;
                    byte[] resultOfBinary;
                    FileResObject resObject = new FileResObject();
                    FileResult fileResult = ConvertorEntrance.parseFile(fileList.get(fileId), convertor);
                    String beforeFormat = fileResult.getResSql().replaceAll("\\s+", "");
                    String afterFormat = SqlFormatter.format((String)fileResult.getResSql()).replaceAll("\\s+", "");
                    if (beforeFormat.equalsIgnoreCase(afterFormat)) {
                        if (!oriDataBase.equalsIgnoreCase("hive")) {
                            resultOfBinary = SqlString.handleErrorRes(SqlFormatter.format((String)fileResult.getResSql())).getBytes(StandardCharsets.UTF_8);
                        } else {
                            SqlFormatter.Formatter of = SqlFormatter.of((Dialect)Dialect.MySql);
                            String res = of.format(fileResult.getResSql());
                            resultOfBinary = SqlString.handleErrorRes(res).getBytes(StandardCharsets.UTF_8);
                        }
                    } else {
                        resultOfBinary = fileResult.getResSql().getBytes(StandardCharsets.UTF_8);
                    }
                    presentRes += 1.0;
                    String string = status = fileResult.getFailSqlCounts() > 0 ? "FAIL" : "SUCCESS";
                    if (fileResult.getFailSqlCounts() > 0) {
                        taskStatus = "FAIL";
                    }
                    int preRes = (int)(presentRes / (double)fileCount * 100.0);
                    resObject.setResFile(resultOfBinary);
                    resObject.setPresentRes(preRes);
                    resObject.setFileStatus(status);
                    resObject.setFailSqlLog(fileResult.getLog().getBytes(StandardCharsets.UTF_8));
                    resObject.setFileId(fileId);
                    if ((int)presentRes != fileCount) {
                        resObject.setTaskStatus("RUNNING");
                    } else {
                        resObject.setTaskStatus(taskStatus);
                    }
                    fileObject.dealWithRes(resObject);
                }
                catch (Exception e) {
                    FileResObject resObject = new FileResObject();
                    resObject.setResFile(null);
                    resObject.setPresentRes(0);
                    resObject.setFileStatus(null);
                    resObject.setFailSqlLog(e.getMessage().getBytes(StandardCharsets.UTF_8));
                    resObject.setFileId(fileId);
                    if ((int)presentRes != fileCount) {
                        resObject.setTaskStatus("RUNNING");
                    } else {
                        resObject.setTaskStatus(taskStatus);
                    }
                    fileObject.dealWithRes(resObject);
                }
            }
        }
        catch (Exception e) {
            throw new ParserException(e.getMessage());
        }
        finally {
            if (oriDataBase.equalsIgnoreCase("mysql") || oriDataBase.equalsIgnoreCase("adb") || oriDataBase.equalsIgnoreCase("bigquery")) {
                MySqlPropertyLoader.clearPropMapCxt();
            } else if (oriDataBase.equalsIgnoreCase("oracle")) {
                OraclePropertyLoader.clearPropMapCxt();
            } else if (oriDataBase.equalsIgnoreCase("hologres") || oriDataBase.equalsIgnoreCase("redshift")) {
                PgPropertyLoader.clearPropMapCxt();
            } else if (oriDataBase.equalsIgnoreCase("hive")) {
                HivePropertyLoader.clearPropMapCxt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SingleResObject convertSingleClause(String oriDataBase, String oriSql, Map<String, String> configProperties) {
        SingleResObject singleResObject = new SingleResObject();
        StringBuilder sb = new StringBuilder();
        PlaceHolderParam placeHolderParam = new PlaceHolderParam(configProperties.get("table.output.placeholder.format"));
        MigrationContextUtil.setPlaceHolderParam(placeHolderParam);
        configProperties.put("table.origin.database.type", oriDataBase);
        try {
            Object convertor;
            switch (oriDataBase) {
                case "adb": 
                case "mysql": 
                case "bigquery": {
                    MySqlPropertyLoader.loadPropertyMap(configProperties);
                    convertor = new MysqlConvertor(null);
                    break;
                }
                case "oracle": {
                    OraclePropertyLoader.loadPropertyMap(configProperties);
                    convertor = new OracleConvertor(null);
                    break;
                }
                case "greenplum": 
                case "hologres": 
                case "redshift": {
                    PgPropertyLoader.loadPropertyMap(configProperties);
                    convertor = new PgConvertor(null);
                    break;
                }
                case "hive": {
                    HivePropertyLoader.loadPropertyMap(configProperties);
                    convertor = new HiveConvertor(null);
                    break;
                }
                default: {
                    throw new ParserException("Not Support Ori DataBase :" + oriDataBase);
                }
            }
            sb.append(oriSql);
            convertor.reset();
            convertor.parse(sb.toString());
            ISqlString str = convertor.convert();
            sb.delete(0, sb.length());
            String beforeFormat = str.toString().replaceAll("\\s+", "");
            String afterFormat = SqlFormatter.format((String)str.toString()).replaceAll("\\s+", "");
            if (beforeFormat.equalsIgnoreCase(afterFormat)) {
                SqlFormatter.Formatter of = SqlFormatter.of((Dialect)Dialect.PostgreSql);
                singleResObject.setRes(SqlString.handleErrorRes(of.format(str.toString(), placeHolderParam.getPlaceHolderMap())));
            } else {
                singleResObject.setRes(str.toString());
            }
            singleResObject.setStatus(0);
        }
        catch (com.huawei.hwclouds.scs.sql.util.ParserRuntimeException e) {
            singleResObject.setRes(e.getMessage());
            singleResObject.setStatus(1);
        }
        catch (ParserRuntimeException e) {
            singleResObject.setRes(e.getMessage());
            singleResObject.setStatus(1);
            singleResObject.setErrorCode(e.getExceptionCode());
        }
        catch (ParserException e) {
            singleResObject.setRes(e.getMessage());
            singleResObject.setStatus(2);
            singleResObject.setErrorCode(ParserExceptionDef.SQL_PARSER_EXCEPTION.getExceptionCode());
        }
        catch (Exception e) {
            singleResObject.setRes(e.getMessage());
            singleResObject.setStatus(3);
            singleResObject.setErrorCode(ParserExceptionDef.UNKNOWN_EXCEPTION.getExceptionCode());
        }
        finally {
            MigrationContextUtil.removeContext();
            MySqlPropertyLoader.clearPropMapCxt();
        }
        return singleResObject;
    }

    private static FileResult parseFile(File file, DatabaseConvertor convertor) throws IOException {
        LineIterator it = FileUtils.lineIterator(file, "UTF8");
        FileResult fileResult = new FileResult();
        StringBuilder sb = new StringBuilder();
        StringBuilder resSql = new StringBuilder();
        ArrayList<String> exceptionList = new ArrayList<String>();
        while (it.hasNext()) {
            String line = it.nextLine();
            if (ConvertorEntrance.lineIsComment(line, sb, it) || (line = DWSMigration.getBeginWithEndString(sb, it, line)) == null) continue;
            if (line != null && line.trim().endsWith(";")) {
                int length = line.trim().length();
                if (length == 1) {
                    String lastInput = sb.toString().trim();
                    sb.delete(0, sb.length());
                    sb.append(lastInput);
                }
                sb.append(line);
                String altString = sb.toString().toUpperCase(Locale.ROOT);
                if (altString.contains("SET @@") || altString.contains("SET @")) {
                    StringBuilder sql = new StringBuilder();
                    resSql.append((CharSequence)sql.append("/* sql not support\r\n").append((CharSequence)sb).append("*/;"));
                    exceptionList.add("Sql syntax not supported:PLSQL SET @@/@, FileName:" + file.getName() + ", OriSql:" + sb + "\r\n");
                } else {
                    ConvertorEntrance.doConvert(convertor, file, sb, resSql, exceptionList);
                    resSql.append(System.lineSeparator());
                }
                sb.append(System.lineSeparator());
                sb.delete(0, sb.length());
                continue;
            }
            sb.append(line);
            if (line.isEmpty() && sb.toString().trim().isEmpty()) {
                resSql.append(System.lineSeparator());
                continue;
            }
            sb.append(System.lineSeparator());
        }
        ConvertorEntrance.doConvert(convertor, file, sb, resSql, exceptionList);
        fileResult.setLog(ConvertorEntrance.listToString(exceptionList));
        fileResult.setResSql(resSql.toString());
        fileResult.setFailSqlCounts(exceptionList.size());
        return fileResult;
    }

    private static void doConvert(DatabaseConvertor convertor, File file, StringBuilder sb, StringBuilder resSql, List<String> exceptionList) {
        try {
            ISqlString str = null;
            convertor.reset();
            convertor.parse(sb.toString());
            str = convertor.convert();
            resSql.append(str.getSql());
        }
        catch (com.huawei.hwclouds.scs.sql.util.ParserRuntimeException ex) {
            exceptionList.add("Sql syntax not supported:" + ex.getMessage() + ", FileName:" + file.getName() + ", OriSql:" + sb);
            resSql.append("/* sql not support\r\n").append((CharSequence)sb).append("*/;");
        }
        catch (ParserException e) {
            exceptionList.add("Sql parser failed:" + e.getMessage() + " FileName:" + file.getName() + ", OriSql:" + sb);
            resSql.append("/* sql not support\r\n").append((CharSequence)sb).append("*/;");
        }
        catch (Exception e) {
            exceptionList.add("Sql convert failed, FileName:" + file.getName() + ", OriSql:" + sb);
            resSql.append("/* sql not support\r\n").append((CharSequence)sb).append("*/;");
        }
    }

    private static boolean lineIsComment(String line, StringBuilder sb, LineIterator it) {
        if (line != null && DWSMigration.isSqlComment(line)) {
            sb.append(line);
            sb.append(System.lineSeparator());
            if (line.trim().startsWith("/*")) {
                while (!line.trim().startsWith("*/") && !line.trim().endsWith("*/") && it.hasNext()) {
                    line = it.nextLine();
                    sb.append(line).append('\n');
                }
            }
            return true;
        }
        return false;
    }

    private static String listToString(List<String> list) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            res.append(list.get(i)).append("\n");
        }
        return res.toString();
    }
}

