/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migrationwrapper;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Help {
    private static final Logger logger = LogManager.getLogger(Help.class);
    private static int zero = 0;
    private static String empty = "";
    private static String fourSpace = "    ";
    private static String version = "v2.0.0";
    private static ThreadLocal<BufferedWriter> sWriterLocal = new ThreadLocal();

    protected static String getVersion() {
        return version;
    }

    protected static void displayHelp() {
        if (Help.toLower(System.getProperty("os.name")).contains("windows")) {
            Help.displayHelpCommon("runDSC.bat");
        } else {
            Help.displayHelpCommon("runDSC.sh");
        }
    }

    protected static void displayHelpCommon(String shellScriptName) {
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage("To migrate teradata/oracle/netezza/mysql/db2 database scripts to GaussDB A/T.");
        Help.printConsoleMessage("" + shellScriptName + " -S <source-database> [-T <target-database>] [-I <input-script-path>] [-O <output-script-path>] [-M <conversion-type>]  [-A <application-lang>]  [-L <log-path>] [-P <pre-execution-path>]");
        Help.printConsoleForSrcTarIO();
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-M | --conversion-type");
        Help.printConsoleMessage(fourSpace + "The conversion type, which can be either DDL or PLSQL. DSC Tool assumes DDL as default Conversion type.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-A | --application-lang");
        Help.printConsoleMessage(fourSpace + "The application language type, which can be either SQL or Perl. DSC Tool assumes SQL as default Application Language type.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-L | --log-folder");
        Help.printConsoleMessage(fourSpace + "The log file path where the log files are created.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-V | --version");
        Help.printConsoleMessage(fourSpace + "To display DSC version details.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-H | --help");
        Help.printConsoleMessage(fourSpace + "To display DSC help details.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "guessencoding -F <filename>");
        Help.printConsoleMessage(fourSpace + "[Internal] To guess encoding for a file.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-F | --file-name");
        Help.printConsoleMessage(fourSpace + "The filename for which the encoding must be guessed.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-P | --pre-execution-path");
        Help.printConsoleMessage(fourSpace + " Path containig the dependent Objects scripts which needs to be executed before the verification step.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage("Refer the user manual for more details.");
    }

    private static void printConsoleForSrcTarIO() {
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-S | --source-db");
        Help.printConsoleMessage(fourSpace + "The source database, which can be either Teradata or Oracle or Netezza or MySql or DB2.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-T | --target-db");
        Help.printConsoleMessage(fourSpace + "The target database, which can be either GaussDBT or GaussDBA. DSC Tool assumes GaussDBA as default target database.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-I | --input-folder");
        Help.printConsoleMessage(fourSpace + "The input/source folder that contains the Teradata/Oracle/Netezza/MySql/DB2 scripts to be migrated. DSC Tool assumes current path as default input folder path.");
        Help.printConsoleMessage(empty);
        Help.printConsoleMessage(fourSpace + "-O | --output-folder");
        Help.printConsoleMessage(fourSpace + "The output/target folder where the migrated scripts are placed. DSC Tool assumes current path as default output folder path.");
    }

    protected static void displayVersion() {
        Properties configFile;
        block13: {
            configFile = new Properties();
            String configPath = null;
            try {
                configPath = "/META-INF/git.properties";
                try (InputStream ipStream = Help.class.getResourceAsStream(configPath);){
                    if (null != ipStream) {
                        configFile.load(ipStream);
                        break block13;
                    }
                    Help.printConsoleMessage("Version: GaussDB Tools DSC " + Help.getVersion());
                    return;
                }
            }
            catch (IOException e) {
                Help.printConsoleMessage("Version: GaussDB Tools DSC " + Help.getVersion());
                return;
            }
        }
        String gitCommitAbbrev = null;
        String configValue = configFile.getProperty("git.commit.id.abbrev");
        if (null != configValue) {
            gitCommitAbbrev = configValue;
        }
        String gitBuildTime = null;
        configValue = configFile.getProperty("git.build.time");
        if (null != configValue) {
            gitBuildTime = configValue;
        }
        if (gitCommitAbbrev != null && gitBuildTime != null) {
            Help.printConsoleMessage("Version: GaussDB Tools DSC " + Help.getVersion() + " build " + gitCommitAbbrev + " compiled at " + gitBuildTime);
        } else {
            Help.printConsoleMessage("Version: GaussDB Tools DSC " + Help.getVersion());
        }
    }

    protected static void displayVersionHelp(String[] args) {
        if ("--version".equalsIgnoreCase(args[zero]) || "-V".equalsIgnoreCase(args[zero])) {
            Help.displayVersion();
        } else if ("--help".equalsIgnoreCase(args[zero]) || "-H".equalsIgnoreCase(args[zero])) {
            Help.displayHelp();
        } else {
            Help.printConsoleMessage("Please enter valid Input parameters, Kindly refer the user manual to execute.");
        }
    }

    public static void printConsoleMessage(String messageInp) {
        Help.writeToLogFile(messageInp);
        logger.info(messageInp);
    }

    public static void printErrorMessage(String messageInp) {
        Help.writeToLogFile(messageInp);
        logger.error(messageInp);
    }

    private static void writeToLogFile(String messageInp) {
        if (sWriterLocal.get() != null) {
            try {
                sWriterLocal.get().write(messageInp);
                sWriterLocal.get().write(System.lineSeparator());
                sWriterLocal.get().flush();
            }
            catch (IOException e) {
                logger.error("Error in printing the log.");
            }
        }
    }

    public static void openConsoleStream() {
        try {
            sWriterLocal.set(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("file.encoding"))));
        }
        catch (Exception e) {
            logger.error("Error in loading log writer");
        }
    }

    public static String toLower(String input) {
        String inputString = null;
        inputString = input != null ? input.toLowerCase(Locale.ROOT) : "";
        return inputString;
    }

    public static void closeConsoleStream() {
        sWriterLocal.remove();
    }

    static {
        Help.openConsoleStream();
    }
}

