/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.migrationwrapper;

import com.huawei.db.migration.exception.FileException;
import com.huawei.db.migration.util.SetFilePermission;
import com.huawei.migrationwrapper.CommandExecutor;
import com.huawei.migrationwrapper.EncodingDetector;
import com.huawei.migrationwrapper.Help;
import com.huawei.migrationwrapper.Main;
import com.huawei.migrationwrapper.MigrationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public class MigrationWrapper {
    private static final String MAX_JVM_LIMIT = "102400m";
    private String sourceDb = null;
    private String targetDb = null;
    private Path inputFolder = null;
    private Path outputFolder = null;
    private String migrationType = "bulk";
    private String migrationUserType = "ddl";
    private String applicationLang = "sql";
    private String fileName = null;
    private Path logFolder = null;
    private String toolHome = null;
    private String log4jXml = null;
    private String jarFile = null;
    private String initialJvmMemory = "256m";
    private String maxJvmMemory = "1024m";
    private boolean isGuessEncoding = false;
    private String osName = System.getProperty("os.name");
    private String versionNumber = null;
    private String preExecutionPath = null;

    protected void setCliArgs(String[] args) throws MigrationException, FileException {
        if (this.isAdmin()) {
            Help.printErrorMessage("[DSC_ERR_005_005] Root privileged users are not allowed to execute the DSC.");
            throw new MigrationException("[DSC_ERR_005_005] Root privileged users are not allowed to execute the DSC");
        }
        this.setToolHome();
        this.getCommandLineArgs(args);
        if (!this.isGuessEncoding) {
            Properties configFile = this.loadApplicationProp();
            this.validateCommandLineArgs(configFile);
            this.setJarFile();
            this.setLog4jXml();
            this.setJvmMemory(configFile);
        }
    }

    public boolean isGuessEncoding() {
        return this.isGuessEncoding;
    }

    protected void setToolHome() {
        try {
            File currentJarFilePath = new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            this.toolHome = currentJarFilePath.getParentFile().getParent();
        }
        catch (URISyntaxException ex) {
            Help.printErrorMessage("URISyntaxException while fetching the tool home path");
        }
    }

    protected String getToolHome() {
        return this.toolHome;
    }

    protected String getJarFile() {
        return this.jarFile;
    }

    protected String getSourceDb() {
        return this.sourceDb;
    }

    protected String getTargetDb() {
        return this.targetDb;
    }

    protected String getInputFolder() {
        return this.inputFolder.toString();
    }

    protected String getOutputFolder() {
        return this.outputFolder.toString();
    }

    protected String getMigrationType() {
        return this.migrationType;
    }

    protected String getMigrationUserType() {
        return this.migrationUserType;
    }

    protected String getApplicationLang() {
        return this.applicationLang;
    }

    protected String getLogFolder() {
        if (null != this.logFolder) {
            return this.logFolder.toString();
        }
        return null;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getlog4jXml() {
        return this.log4jXml;
    }

    protected String getInitialJvmMemory() {
        return this.initialJvmMemory;
    }

    protected String getMaxJvmMemory() {
        return this.maxJvmMemory;
    }

    private String getVersionNumber() {
        return this.versionNumber;
    }

    private String getPreExecutionPath() {
        return this.preExecutionPath;
    }

    protected void setJarFile() {
        String sourceDataBase;
        switch (sourceDataBase = this.getSourceDb().toLowerCase(Locale.ROOT)) {
            case "mysql": 
            case "adb": 
            case "bigquery": 
            case "doris": 
            case "starrocks": 
            case "sqlserver": 
            case "synapse": {
                this.jarFile = this.getToolHome().concat(File.separator).concat("bin").concat(File.separator).concat("mysql-dsc.jar");
                break;
            }
            case "oracle-antlr": {
                this.jarFile = this.getToolHome().concat(File.separator).concat("bin").concat(File.separator).concat("oracle2dws-dsc.jar");
                break;
            }
            case "hive": 
            case "impala": {
                this.jarFile = this.getToolHome().concat(File.separator).concat("bin").concat(File.separator).concat("hive-dsc.jar");
                break;
            }
            case "teradata": {
                this.jarFile = this.getToolHome().concat(File.separator).concat("bin").concat(File.separator).concat("td-dsc.jar");
                break;
            }
            case "postgres": 
            case "greenplum": 
            case "hologres": 
            case "redshift": {
                this.jarFile = this.getToolHome().concat(File.separator).concat("bin").concat(File.separator).concat("pg-dsc.jar");
                break;
            }
            default: {
                this.jarFile = this.getToolHome().concat(File.separator).concat("bin").concat(File.separator).concat("dsc.jar");
            }
        }
    }

    protected void setLog4jXml() {
        String osInfo = System.getProperty("os.name");
        this.log4jXml = null != osInfo && osInfo.toLowerCase(Locale.ROOT).contains("windows") ? "\\".concat(this.getToolHome()) : this.getToolHome();
        this.log4jXml = this.log4jXml.concat(File.separator).concat("config").concat(File.separator).concat("log4j2.xml");
    }

    protected void executeMigrationCommand() throws MigrationException {
        if (this.isGuessEncoding) {
            EncodingDetector encDetector = new EncodingDetector();
            encDetector.identifyEncoding(this.getFileName());
            return;
        }
        Properties configFile = this.loadApplicationProp();
        String timeoutProp = configFile.getProperty("Timeout");
        int timeout = this.parseConfigValue(timeoutProp);
        if (timeout == 0) {
            timeout = 4;
        }
        if (this.getApplicationLang().equalsIgnoreCase("perl")) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("perl");
            command.add("-I".concat(this.getToolHome()).concat(File.separator).concat("scripts").concat(File.separator).concat("perl").concat(File.separator));
            command.add(this.getToolHome().concat(File.separator).concat("scripts").concat(File.separator).concat("perl").concat(File.separator).concat("sqlTDtoGS.pl"));
            command.add("--target-db=".concat(this.getTargetDb()));
            command.add("--input-folder=".concat(this.getInputFolder()));
            command.add("--dsc-path=".concat(this.getToolHome()));
            command.add("--output-folder=".concat(this.getOutputFolder()));
            command.add("--log-folder=".concat(this.getLogFolder()));
            CommandExecutor.executeCmd(command, true, false, timeout);
        } else if (this.getApplicationLang().equalsIgnoreCase("perl-internal")) {
            List<String> command = this.buildCommand(true);
            CommandExecutor.executeCmd(command, true, true, timeout);
        } else {
            List<String> command = this.buildCommand(false);
            CommandExecutor.executeCmd(command, true, true, timeout);
        }
    }

    private List<String> buildCommand(boolean isPerlMigration) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-Xms".concat(this.getInitialJvmMemory()));
        command.add("-Xmx".concat(this.getMaxJvmMemory()));
        command.add("-Dconfig.dir=".concat(this.getToolHome()).concat(File.separator).concat("config"));
        command.add("-Dlog4j.configurationFile=file:".concat(this.getlog4jXml()));
        command.add("-DLOGFILE_PATH=".concat(this.getLogFolder()));
        if (isPerlMigration) {
            command.add("-DAPPLICATION_LANG=".concat("perl"));
        }
        command.add("-jar");
        command.add(this.getJarFile());
        switch (this.getSourceDb().toLowerCase(Locale.ROOT)) {
            case "oracle": 
            case "netezza": 
            case "db2": {
                command.add(this.getInputFolder());
                command.add(this.getOutputFolder());
                break;
            }
        }
        switch (this.getSourceDb().toLowerCase(Locale.ROOT)) {
            case "oracle": 
            case "netezza": 
            case "db2": {
                command.add(this.getSourceDb());
                command.add(this.getMigrationType());
                break;
            }
        }
        switch (this.getSourceDb().toLowerCase(Locale.ROOT)) {
            case "mysql": 
            case "adb": 
            case "bigquery": 
            case "doris": 
            case "starrocks": 
            case "synapse": 
            case "sqlserver": 
            case "oracle-antlr": 
            case "teradata": 
            case "hive": 
            case "impala": 
            case "postgres": 
            case "greenplum": 
            case "hologres": 
            case "redshift": {
                command.add("--input-folder=".concat(this.getInputFolder()));
                command.add("--output-folder=".concat(this.getOutputFolder()));
                command.add("--source-db=".concat(this.getSourceDb()));
                command.add("--log-folder=".concat(this.getLogFolder()));
                break;
            }
        }
        command.add(this.getTargetDb());
        if (this.getPreExecutionPath() != null) {
            command.add(this.getPreExecutionPath());
        }
        return command;
    }

    protected boolean isAdmin() throws MigrationException {
        String osInfo = System.getProperty("os.name");
        if (null == osInfo || !osInfo.toLowerCase(Locale.ROOT).contains("windows")) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("id");
            command.add("-u");
            String isRootOutput = CommandExecutor.executeCmd(command, false);
            try {
                if (0 == Integer.parseInt(isRootOutput)) {
                    return true;
                }
            }
            catch (NumberFormatException ex) {
                Help.printErrorMessage("[DSC_ERR_005_006] Error while getting the id of os user used to execute the DSC.");
                throw new MigrationException("[DSC_ERR_005_006] Error while getting the id of os user used to execute the DSC");
            }
            return false;
        }
        return false;
    }

    public void getConversionType(CommandLine line) throws MigrationException {
        try {
            if (null != line.getParsedOptionValue("M")) {
                this.migrationUserType = line.getParsedOptionValue("M").toString();
                this.migrationType = this.getMigrationUserType().equalsIgnoreCase("ddl") ? "bulk" : (this.getMigrationUserType().equalsIgnoreCase("plsql") ? "blogic" : "invalid");
            } else {
                Help.printConsoleMessage("Conversion type is not provided, DSC Tool assumes DDL as the default conversion type.");
            }
        }
        catch (ParseException e) {
            Help.printErrorMessage("[DSC_ERR_005_007] Arguments specified is not valid, please check the user manual for the command line arguments.");
            throw new MigrationException("[DSC_ERR_005_007] Arguments specified is not valid, please check the user manual for the command line arguments.");
        }
    }

    protected void getCommandLineArgs(String[] args) throws MigrationException {
        DefaultParser parser = new DefaultParser();
        Options options = this.setOptionsParameters();
        try {
            CommandLine line = this.logHelp(args, parser, options);
            String[] remArgs = line.getArgs();
            if (remArgs.length > 1) {
                this.logError(remArgs);
            } else if (remArgs.length == 1) {
                if (remArgs[0].equalsIgnoreCase("guessencoding")) {
                    if (null != line.getOptionValue("F")) {
                        this.fileName = line.getOptionValue("F");
                        this.isGuessEncoding = true;
                        return;
                    }
                    Help.printErrorMessage("[DSC_ERR_005_008] file-name option not specified for guessencoding.");
                    throw new MigrationException("[DSC_ERR_005_008] file-name option not specified for guessencoding.");
                }
                Help.printErrorMessage("[DSC_ERR_005_009] Invalid argument " + remArgs[0] + " specified.");
                Help.displayHelp();
                throw new MigrationException("[DSC_ERR_005_009] Invalid argument " + remArgs[0] + " specified.");
            }
            boolean check = this.getChkFlag(args, line);
            if (check) {
                Help.printErrorMessage("[DSC_ERR_005_007] Arguments specified is not valid, please check the user manual for the command line arguments");
                throw new MigrationException("[DSC_ERR_005_007] Arguments specified is not valid, please check the user manual for the command line arguments");
            }
        }
        catch (UnrecognizedOptionException e) {
            this.printErrorMsg();
        }
        catch (ParseException e) {
            this.printErrorMsg();
        }
    }

    private boolean getChkFlag(String[] args, CommandLine line) throws MigrationException, ParseException {
        this.getSourceDb(line);
        this.getTargetDb(line);
        if (null != line.getOptionValue("I")) {
            this.inputFolder = Paths.get(line.getOptionValue("I"), new String[0]);
        }
        if (null != line.getOptionValue("O")) {
            this.outputFolder = Paths.get(line.getOptionValue("O"), new String[0]);
        }
        this.getConversionType(line);
        this.getCommandLineArg(line);
        boolean check = this.checkDuplicateArgument(args);
        return check;
    }

    private void printErrorMsg() throws MigrationException {
        Help.printErrorMessage("[DSC_ERR_005_001] Error while executing command, command specified is not valid. Please check the user manual for the command line arguments.");
        throw new MigrationException("[DSC_ERR_005_001] Error while executing command, command specified is not valid. Please check the user manual for the command line arguments.");
    }

    private void logError(String[] remArgs) throws MigrationException {
        String arrayStr = Arrays.toString(remArgs);
        Help.printErrorMessage("[DSC_ERR_005_001] Error while executing command, command specified is not valid. " + arrayStr);
        Help.displayHelp();
        throw new MigrationException("[DSC_ERR_005_001] Error while executing command, command specified is not valid. " + arrayStr);
    }

    private CommandLine logHelp(String[] args, CommandLineParser parser, Options options) throws ParseException, MigrationException {
        CommandLine line = parser.parse(options, args);
        if (line.hasOption("help")) {
            Help.displayHelp();
            throw new MigrationException("Help command specified.");
        }
        if (line.hasOption("version")) {
            Help.displayVersion();
            throw new MigrationException("Version command specified.");
        }
        return line;
    }

    private boolean checkDuplicateArgument(String[] args) {
        boolean check = false;
        List<String> argsList = Arrays.asList(args);
        HashSet<String> uniqueSet = new HashSet<String>(argsList);
        if (!argsList.contains(".")) {
            check = uniqueSet.size() != argsList.size();
        }
        return check;
    }

    private void getCommandLineArg(CommandLine line) throws ParseException {
        if (null != line.getParsedOptionValue("A")) {
            this.applicationLang = line.getParsedOptionValue("A").toString();
        }
        if (null != line.getOptionValue("L")) {
            this.logFolder = Paths.get(line.getOptionValue("L"), new String[0]);
        }
        if (null != line.getOptionValue("VN")) {
            this.versionNumber = line.getOptionValue("VN");
        }
        if (null != line.getOptionValue("P")) {
            this.preExecutionPath = line.getOptionValue("P");
        }
    }

    public void getSourceDb(CommandLine line) throws MigrationException {
        this.sourceDb = line.getOptionValue("S");
        if (null == this.sourceDb) {
            Help.printErrorMessage("[DSC_ERR_005_010] Source database is not set. Please enter a valid source db and refer the user manual for syntax.");
            throw new MigrationException("[DSC_ERR_005_010] Source database is not set. Please enter a valid source db and refer the user manual for syntax.");
        }
    }

    public void getTargetDb(CommandLine line) throws MigrationException {
        this.targetDb = line.getOptionValue("T");
        if (this.targetDb != null && this.targetDb.equalsIgnoreCase("GaussDBT") && !this.sourceDb.equalsIgnoreCase("Oracle") && !this.sourceDb.equalsIgnoreCase("db2")) {
            this.throwInvalidTarget();
        } else if (this.targetDb != null && this.targetDb.equalsIgnoreCase("GaussDBA") && this.sourceDb.equalsIgnoreCase("db2")) {
            this.throwInvalidTarget();
        } else if (null == this.targetDb) {
            this.targetDb = "GaussDBA";
            Help.printErrorMessage("TargetDB is not provided, DSC Tool assumes GaussDBA as the default TargetDB.");
        }
    }

    private void throwInvalidTarget() throws MigrationException {
        Help.printErrorMessage("[DSC_ERR_005_011] " + this.sourceDb + " to " + this.targetDb + ", hence DSC is not supported.");
        throw new MigrationException("[DSC_ERR_005_011] " + this.sourceDb + " to " + this.targetDb + ", hence DSC is not supported.");
    }

    private Options setOptionsParameters() {
        Options options = new Options();
        options.addOption("S", "source-db", true, "The source database, which can be either Teradata, Oracle, Mysql or Netezza or DB2");
        options.addOption("T", "target-db", true, "The target database, which can be either GaussDBT or GaussDBA");
        options.addOption("I", "input-folder", true, "The input/source folder that contains the Teradata/Oracle/Netezza/DB2 scripts to be migrated.");
        options.addOption("O", "output-folder", true, "The output/target folder where the migrated scripts are placed.");
        options.addOption("M", "conversion-type", true, "The dsc type, which can be either DDL or PLSQL.");
        options.addOption("A", "application-lang", true, "The application language type, which can be either SQL or Perl.");
        options.addOption("L", "log-folder", true, "The log file path where the log files are created.");
        options.addOption("F", "file-name", true, "The file for which encoding need to be guessed.");
        options.addOption("VN", "version-number", true, "The version number, which can be either V1R7 or V1R8_330.");
        options.addOption("help", "help", false, "help command");
        options.addOption("P", "pre-execution-path", true, " Path containig the dependent Objects scripts which needs to be executed before the verification step.");
        options.addOption("version", "version", false, "version command");
        return options;
    }

    protected void setJvmMemory(Properties configFile) throws MigrationException {
        String initialConfigValue = configFile.getProperty("initialJVMMemory");
        String maxConfigValue = configFile.getProperty("maxJVMMemory");
        if (this.parseConfigValue(initialConfigValue) > this.parseConfigValue(maxConfigValue)) {
            Help.printErrorMessage("[DSC_ERR_005_013] Initial JVM memory is greater than maximum JVM memory.");
            throw new MigrationException("[DSC_ERR_005_013] Initial JVM memory is greater than maximum JVM memory.");
        }
        this.initialJvmMemory = this.getConfigValue(this.initialJvmMemory, initialConfigValue);
        this.maxJvmMemory = this.getConfigValue(this.maxJvmMemory, maxConfigValue);
    }

    public Properties loadApplicationProp() throws MigrationException {
        Properties configFile = new Properties();
        String configPath = null;
        try {
            configPath = this.getToolHome().concat(File.separator).concat("config").concat(File.separator).concat("application.properties");
            File cfgFile = new File(this.getToolHome().concat(File.separator).concat("config"), "application.properties");
            try (FileInputStream ipStream = new FileInputStream(cfgFile);){
                configFile.load(ipStream);
            }
        }
        catch (IOException e) {
            Help.printErrorMessage("[DSC_ERR_005_012] Loading file " + configPath + " failed with IOException");
            throw new MigrationException("[DSC_ERR_005_012] Loading file " + configPath + " failed with IOException");
        }
        return configFile;
    }

    public String getConfigValue(String minValue, String configValueIn) throws MigrationException {
        String configValue = configValueIn;
        int minIntValue = this.parseConfigValue(minValue);
        int configIntValue = this.parseConfigValue(configValue);
        int maxIntValue = this.parseConfigValue(MAX_JVM_LIMIT);
        if (configIntValue < minIntValue) {
            configValue = minValue;
        } else if (configIntValue > maxIntValue) {
            configValue = MAX_JVM_LIMIT;
        }
        return configValue;
    }

    private int parseConfigValue(String configValue) throws MigrationException {
        int result = 0;
        try {
            result = Integer.parseInt(configValue.replace("m", ""));
        }
        catch (NumberFormatException e) {
            Help.printErrorMessage("I[DSC_ERR_005_014] Invalid value  specified for configValue " + configValue);
            throw new MigrationException("[DSC_ERR_005_014] Invalid value  specified for configValue " + configValue);
        }
        return result;
    }

    private void validateSetCommandLineArgs() throws MigrationException {
        boolean sourceDbCondition;
        boolean bl = sourceDbCondition = this.getSourceDb() != null;
        if (sourceDbCondition) {
            switch (this.getSourceDb().toLowerCase(Locale.ROOT)) {
                case "oracle": 
                case "teradata": 
                case "netezza": 
                case "mysql": 
                case "adb": 
                case "db2": 
                case "oracle-antlr": 
                case "hive": 
                case "impala": 
                case "postgres": 
                case "bigquery": 
                case "doris": 
                case "starrocks": 
                case "synapse": 
                case "sqlserver": 
                case "greenplum": 
                case "hologres": 
                case "redshift": {
                    break;
                }
                default: {
                    Help.printErrorMessage("[DSC_ERR_005_015] Invalid source database specified for source-db option. " + this.getSourceDb());
                    throw new MigrationException("[DSC_ERR_005_015] Invalid source database specified for source-db option. " + this.getSourceDb());
                }
            }
        } else {
            Help.printErrorMessage("[DSC_ERR_005_015] Invalid source database specified for source-db option. " + this.getSourceDb());
            throw new MigrationException("[DSC_ERR_005_015] Invalid source database specified for source-db option. " + this.getSourceDb());
        }
        if (this.getTargetDb() != null && !this.getTargetDb().equalsIgnoreCase("GaussDBT") && !this.getTargetDb().equalsIgnoreCase("GaussDBA")) {
            Help.printErrorMessage("[DSC_ERR_005_016] Invalid target database specified for target-db option. " + this.getTargetDb());
            throw new MigrationException("[DSC_ERR_005_016] Invalid target database specified for target-db option. " + this.getTargetDb());
        }
        if (!this.getMigrationType().equalsIgnoreCase("bulk") && !this.getMigrationType().equalsIgnoreCase("blogic")) {
            Help.printErrorMessage("[DSC_ERR_005_017] Invalid conversion type specified for dsc-type option - " + this.getMigrationUserType() + ". Should be DDL or PLSQL.");
            throw new MigrationException("[DSC_ERR_005_017] Invalid conversion type specified for dsc-type option - " + this.getMigrationUserType() + ". Should be DDL or PLSQL.");
        }
        if (!(this.getApplicationLang().equalsIgnoreCase("perl") || this.getApplicationLang().equalsIgnoreCase("perl-internal") || this.getApplicationLang().equalsIgnoreCase("sql"))) {
            Help.printErrorMessage("[DSC_ERR_005_018] Invalid application language specified for application-lang option. " + this.getApplicationLang());
            throw new MigrationException("[DSC_ERR_005_018] Invalid application language specified for application-lang option. " + this.getApplicationLang());
        }
        if (this.getApplicationLang().equalsIgnoreCase("perl") && !this.getMigrationType().equalsIgnoreCase("bulk")) {
            Help.printErrorMessage("[DSC_ERR_005_019] Conversion-type should be DDL for application-lang type as perl");
            throw new MigrationException("[DSC_ERR_005_019] Conversion-type should be DDL for application-lang type as perl");
        }
        if (this.getApplicationLang().equalsIgnoreCase("perl") && !this.getSourceDb().equalsIgnoreCase("teradata")) {
            Help.printErrorMessage("[DSC_ERR_005_020] source-db should be teradata for application-lang type as perl.");
            throw new MigrationException("[DSC_ERR_005_020] source-db should be teradata for application-lang type as perl.");
        }
    }

    protected void validateCommandLineArgs(Properties configFile) throws MigrationException, FileException {
        String inputPath = configFile.getProperty("inputPath");
        String logfilePath = configFile.getProperty("logfilePath");
        this.getOutputFolder(configFile, inputPath, logfilePath);
        if (Files.notExists(this.outputFolder, new LinkOption[0])) {
            boolean newFolCreated = false;
            File outputDir = new File(String.valueOf(this.outputFolder));
            SetFilePermission filePer = new SetFilePermission();
            if (MigrationWrapper.containsCheck(this.osName, "win")) {
                try {
                    newFolCreated = filePer.createFolderWithPermissionInWin(outputDir.getCanonicalPath(), false);
                }
                catch (IOException e) {
                    Help.printErrorMessage("[DSC_ERR_005_031] Error occurred in creating output directory. " + outputDir.toString());
                    throw new MigrationException("[DSC_ERR_005_024] Getting path for output folder " + outputDir.toString() + " failed with IOException");
                }
            }
            try {
                newFolCreated = filePer.createFolderWithPermissionInLinux(outputDir.getCanonicalPath(), false);
            }
            catch (IOException e) {
                Help.printErrorMessage("[DSC_ERR_005_031] Error occurred in creating output directory. " + outputDir.toString());
                throw new MigrationException("[DSC_ERR_005_025] Setting file permission " + this.outputFolder.toString() + " failed with IOException");
            }
            if (!newFolCreated) {
                Help.printErrorMessage("[DSC_ERR_005_031] Error occurred in creating output directory. " + outputDir.toString());
                throw new MigrationException("[DSC_ERR_005_026] Creating directory " + this.outputFolder + " failed.");
            }
        }
        try {
            this.outputFolder = this.outputFolder.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            Help.printErrorMessage("[DSC_ERR_005_024] Getting path for output folder " + this.outputFolder.toString() + " failed with IOException");
            throw new MigrationException("[DSC_ERR_005_024] Getting path for output folder " + this.outputFolder.toString() + " failed with IOException");
        }
        this.validateSetCommandLineArgs();
    }

    private void getOutputFolder(Properties configFile, String inputPath, String logfilePath) throws MigrationException {
        this.getLogFolder(logfilePath);
        this.getInputFolder(inputPath);
        if (Files.notExists(this.inputFolder, new LinkOption[0])) {
            Help.printErrorMessage("[DSC_ERR_005_022] Input folder" + this.inputFolder + " does not exist.");
            throw new MigrationException("[DSC_ERR_005_022] Input folder" + this.inputFolder + " does not exist.");
        }
        try {
            this.inputFolder = this.inputFolder.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            Help.printErrorMessage("[DSC_ERR_005_023] Getting path for input folder failed with IOException");
            throw new MigrationException("[DSC_ERR_005_023] Getting path for input folder failed with IOException");
        }
        String outputPath = configFile.getProperty("outputPath");
        if (null == this.outputFolder) {
            this.outputFolder = !outputPath.equals("./output") ? Paths.get(outputPath, new String[0]) : Paths.get(this.getToolHome().concat(File.separator).concat("output"), new String[0]);
        }
    }

    public void getInputFolder(String inputPath) {
        if (null == this.inputFolder) {
            this.inputFolder = !inputPath.equals("./input") ? Paths.get(inputPath, new String[0]) : Paths.get(this.getToolHome().concat(File.separator).concat("input"), new String[0]);
        }
    }

    public void getLogFolder(String logfilePath) {
        if (null == this.logFolder) {
            this.logFolder = !logfilePath.equals("./log") ? Paths.get(logfilePath, new String[0]) : Paths.get(this.getToolHome().concat(File.separator).concat("log"), new String[0]);
        }
    }

    private static String toLower(String input) {
        String inputString = null;
        inputString = input != null ? input.toLowerCase(Locale.ROOT) : "";
        return inputString;
    }

    private static boolean containsCheck(String var1, String var2) {
        String var1Canon = MigrationWrapper.canonicalizeString(var1);
        String var2Canon = MigrationWrapper.canonicalizeString(var2);
        return MigrationWrapper.toLower(var1Canon).contains(MigrationWrapper.toLower(var2Canon));
    }

    private static String canonicalizeString(String strVal) {
        return strVal != null ? Normalizer.normalize(strVal, Normalizer.Form.NFKC) : null;
    }

    protected void setLogPermission() throws FileException {
        SetFilePermission filePer = new SetFilePermission();
        String logfolder = "";
        logfolder = this.getLogFolder();
        if (null == logfolder) {
            logfolder = "log";
        }
        try {
            File logDir = new File(logfolder);
            if (MigrationWrapper.containsCheck(this.osName, "win")) {
                if (logDir.isDirectory()) {
                    filePer.createFolderWithPermissionInWin(logfolder, true);
                } else {
                    filePer.createFolderWithPermissionInWin(logfolder, false);
                }
                filePer.changeFilePermissionInWin(logfolder);
            } else {
                if (logDir.isDirectory()) {
                    filePer.createFolderWithPermissionInLinux(logfolder, true);
                } else {
                    filePer.createFolderWithPermissionInLinux(logfolder, false);
                }
                filePer.changeFilePermissionInLinux(logfolder);
            }
        }
        catch (FileException e) {
            String outputDir = this.outputFolder != null ? this.outputFolder.toString() : "";
            throw new FileException("[DSC_ERR_005_027] Setting file permissions for log folder/file " + outputDir + " failed with FileException");
        }
    }
}

