/*
 * Decompiled with CFR 0.152.
 */
package com.github.vertical_blank.sqlformatter.core;

import com.github.vertical_blank.sqlformatter.core.DialectConfig;
import com.github.vertical_blank.sqlformatter.core.Token;
import com.github.vertical_blank.sqlformatter.core.TokenTypes;
import com.github.vertical_blank.sqlformatter.core.util.JSLikeList;
import com.github.vertical_blank.sqlformatter.core.util.RegexUtil;
import com.github.vertical_blank.sqlformatter.core.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer {
    private final Pattern NUMBER_PATTERN = Pattern.compile("^((-\\s*)?[0-9]+(\\.[0-9]+)?([eE]-?[0-9]+(\\.[0-9]+)?)?|0x[0-9a-fA-F]+|0b[01]+)\\b");
    private final Pattern OPERATOR_PATTERN;
    private final Pattern BLOCK_COMMENT_PATTERN;
    private final Pattern LINE_COMMENT_PATTERN;
    private final Pattern RESERVED_TOP_LEVEL_PATTERN;
    private final Pattern RESERVED_TOP_LEVEL_NO_INDENT_PATTERN;
    private final Pattern RESERVED_NEWLINE_PATTERN;
    private final Pattern RESERVED_PLAIN_PATTERN;
    private final Pattern WORD_PATTERN;
    private final Pattern STRING_PATTERN;
    private final Pattern OPEN_PAREN_PATTERN;
    private final Pattern CLOSE_PAREN_PATTERN;
    private final Pattern INDEXED_PLACEHOLDER_PATTERN;
    private final Pattern IDENT_NAMED_PLACEHOLDER_PATTERN;
    private final Pattern STRING_NAMED_PLACEHOLDER_PATTERN;

    public Tokenizer(DialectConfig cfg) {
        this.OPERATOR_PATTERN = Pattern.compile(RegexUtil.createOperatorRegex(new JSLikeList<String>(Arrays.asList("<>", "<=", ">=")).with(cfg.operators)));
        this.BLOCK_COMMENT_PATTERN = Pattern.compile("^(/\\*(?s).*?(?:\\*/|$))");
        this.LINE_COMMENT_PATTERN = Pattern.compile(RegexUtil.createLineCommentRegex(new JSLikeList<String>(cfg.lineCommentTypes)));
        this.RESERVED_TOP_LEVEL_PATTERN = Pattern.compile(RegexUtil.createReservedWordRegex(new JSLikeList<String>(cfg.reservedTopLevelWords)));
        this.RESERVED_TOP_LEVEL_NO_INDENT_PATTERN = Pattern.compile(RegexUtil.createReservedWordRegex(new JSLikeList<String>(cfg.reservedTopLevelWordsNoIndent)));
        this.RESERVED_NEWLINE_PATTERN = Pattern.compile(RegexUtil.createReservedWordRegex(new JSLikeList<String>(cfg.reservedNewlineWords)));
        this.RESERVED_PLAIN_PATTERN = Pattern.compile(RegexUtil.createReservedWordRegex(new JSLikeList<String>(cfg.reservedWords)));
        this.WORD_PATTERN = Pattern.compile(RegexUtil.createWordRegex(new JSLikeList<String>(cfg.specialWordChars)));
        this.STRING_PATTERN = Pattern.compile(RegexUtil.createStringRegex(new JSLikeList<String>(cfg.stringTypes)));
        this.OPEN_PAREN_PATTERN = Pattern.compile(RegexUtil.createParenRegex(new JSLikeList<String>(cfg.openParens)));
        this.CLOSE_PAREN_PATTERN = Pattern.compile(RegexUtil.createParenRegex(new JSLikeList<String>(cfg.closeParens)));
        this.INDEXED_PLACEHOLDER_PATTERN = RegexUtil.createPlaceholderRegexPattern(new JSLikeList<String>(cfg.indexedPlaceholderTypes), "[0-9]*");
        this.IDENT_NAMED_PLACEHOLDER_PATTERN = RegexUtil.createPlaceholderRegexPattern(new JSLikeList<String>(cfg.namedPlaceholderTypes), "[a-zA-Z0-9._$]+");
        this.STRING_NAMED_PLACEHOLDER_PATTERN = RegexUtil.createPlaceholderRegexPattern(new JSLikeList<String>(cfg.namedPlaceholderTypes), RegexUtil.createStringPattern(new JSLikeList<String>(cfg.stringTypes)));
    }

    public JSLikeList<Token> tokenize(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Token token = null;
        while (!input.isEmpty()) {
            String[] findBeforeWhitespace = this.findBeforeWhitespace(input);
            String whitespaceBefore = findBeforeWhitespace[0];
            input = findBeforeWhitespace[1];
            if (input.isEmpty()) continue;
            token = this.getNextToken(input, token);
            input = input.substring(token.value.length());
            tokens.add(token.withWhitespaceBefore(whitespaceBefore));
        }
        return new JSLikeList<Token>(tokens);
    }

    private String[] findBeforeWhitespace(String input) {
        int index;
        char[] chars = input.toCharArray();
        int beforeLength = chars.length;
        for (index = 0; index != beforeLength && Character.isWhitespace(chars[index]); ++index) {
        }
        return new String[]{new String(chars, 0, index), new String(chars, index, beforeLength - index)};
    }

    private Token getNextToken(String input, Token previousToken) {
        return (Token)Util.firstNotnull(() -> this.getCommentToken(input), () -> this.getStringToken(input), () -> this.getOpenParenToken(input), () -> this.getCloseParenToken(input), () -> this.getPlaceholderToken(input), () -> this.getNumberToken(input), () -> this.getReservedWordToken(input, previousToken), () -> this.getWordToken(input), () -> this.getOperatorToken(input));
    }

    private Token getCommentToken(String input) {
        return (Token)Util.firstNotnull(() -> this.getLineCommentToken(input), () -> this.getBlockCommentToken(input));
    }

    private Token getLineCommentToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.LINE_COMMENT, this.LINE_COMMENT_PATTERN);
    }

    private Token getBlockCommentToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.BLOCK_COMMENT, this.BLOCK_COMMENT_PATTERN);
    }

    private Token getStringToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.STRING, this.STRING_PATTERN);
    }

    private Token getOpenParenToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.OPEN_PAREN, this.OPEN_PAREN_PATTERN);
    }

    private Token getCloseParenToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.CLOSE_PAREN, this.CLOSE_PAREN_PATTERN);
    }

    private Token getPlaceholderToken(String input) {
        return (Token)Util.firstNotnull(() -> this.getIdentNamedPlaceholderToken(input), () -> this.getStringNamedPlaceholderToken(input), () -> this.getIndexedPlaceholderToken(input));
    }

    private Token getIdentNamedPlaceholderToken(String input) {
        return this.getPlaceholderTokenWithKey(input, this.IDENT_NAMED_PLACEHOLDER_PATTERN, v -> v.substring(1));
    }

    private Token getStringNamedPlaceholderToken(String input) {
        return this.getPlaceholderTokenWithKey(input, this.STRING_NAMED_PLACEHOLDER_PATTERN, v -> this.getEscapedPlaceholderKey(v.substring(2, v.length() - 1), v.substring(v.length() - 1)));
    }

    private Token getIndexedPlaceholderToken(String input) {
        return this.getPlaceholderTokenWithKey(input, this.INDEXED_PLACEHOLDER_PATTERN, v -> v.substring(1));
    }

    private Token getPlaceholderTokenWithKey(String input, Pattern regex, Function<String, String> parseKey) {
        Token token = this.getTokenOnFirstMatch(input, TokenTypes.PLACEHOLDER, regex);
        if (token != null) {
            return token.withKey(parseKey.apply(token.value));
        }
        return token;
    }

    private String getEscapedPlaceholderKey(String key, String quoteChar) {
        return key.replaceAll(RegexUtil.escapeRegExp("\\") + quoteChar, quoteChar);
    }

    private Token getNumberToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.NUMBER, this.NUMBER_PATTERN);
    }

    private Token getOperatorToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.OPERATOR, this.OPERATOR_PATTERN);
    }

    private Token getReservedWordToken(String input, Token previousToken) {
        if (previousToken != null && previousToken.value != null && previousToken.value.equals(".")) {
            return null;
        }
        return (Token)Util.firstNotnull(() -> this.getToplevelReservedToken(input), () -> this.getNewlineReservedToken(input), () -> this.getTopLevelReservedTokenNoIndent(input), () -> this.getPlainReservedToken(input));
    }

    private Token getToplevelReservedToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.RESERVED_TOP_LEVEL, this.RESERVED_TOP_LEVEL_PATTERN);
    }

    private Token getNewlineReservedToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.RESERVED_NEWLINE, this.RESERVED_NEWLINE_PATTERN);
    }

    private Token getTopLevelReservedTokenNoIndent(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.RESERVED_TOP_LEVEL_NO_INDENT, this.RESERVED_TOP_LEVEL_NO_INDENT_PATTERN);
    }

    private Token getPlainReservedToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.RESERVED, this.RESERVED_PLAIN_PATTERN);
    }

    private Token getWordToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.WORD, this.WORD_PATTERN);
    }

    private static String getFirstMatch(String input, Pattern regex) {
        if (regex == null) {
            return null;
        }
        Matcher matcher = regex.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private Token getTokenOnFirstMatch(String input, TokenTypes type, Pattern regex) {
        String firstMatch = Tokenizer.getFirstMatch(input, regex);
        if (firstMatch != null) {
            return new Token(type, firstMatch);
        }
        return null;
    }
}

