/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.common.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;

public class ConvertUtil {
    public static String operatorConvert(String opt) {
        opt = opt.replace("**", "^");
        return opt;
    }

    public static String columnConvert(String column) {
        column = ConvertUtil.singleQuoteConvert(column);
        return column;
    }

    public static String keywordConvert(String input) {
        String keyword;
        String output = null;
        if (input != null && (keyword = (output = input).toUpperCase(Locale.ROOT)).equalsIgnoreCase("ROWID")) {
            output = "CAST ( (xc_node_id || '#' || tableoid || '#' || ctid) AS TEXT) AS ROWID";
        }
        return output;
    }

    public static String functionConvert(String input) {
        String output = input;
        String keyword = output.toUpperCase(Locale.ROOT);
        if ("SYSTIMESTAMP".equals(keyword)) {
            output = "CURRENT_TIMESTAMP";
        }
        return output;
    }

    private static String singleQuoteConvert(String column) {
        String output = column;
        String patternQuote = "(?i)(?<!')q(\\'([\\`|~|!|@|#|$|%|^|*|\\(|\\)|+|\\-|=|\\\\|\\||\\/|{|}|\\[|\\]|:|\\'|\"|<|>|,|.|?|\\w]))";
        Pattern pattern = Pattern.compile(patternQuote);
        Matcher matcher = pattern.matcher(output);
        StringBuffer strOutBuff = new StringBuffer();
        int tempIdx = 0;
        while (matcher.find()) {
            int quoteStartIdx = matcher.start(1);
            int quoteStartEndIdx = matcher.end(1);
            String delimiter = matcher.group(2).trim();
            if (delimiter.equals("(")) {
                delimiter = ")";
            } else if (delimiter.equals("[")) {
                delimiter = "]";
            } else if (delimiter.equals("{")) {
                delimiter = "}";
            } else if (delimiter.equals("<")) {
                delimiter = ">";
            }
            String quoteEndDelimiter = delimiter + "'";
            int quoteEndIdx = ConvertUtil.toLower(output).indexOf(ConvertUtil.toLower(quoteEndDelimiter), quoteStartEndIdx);
            String strWithinQuotes = output.substring(quoteStartEndIdx, quoteEndIdx);
            strOutBuff.append(output, tempIdx, quoteStartIdx - 1).append(" ").append("$q$").append(strWithinQuotes).append("$q$").append(" ");
            tempIdx = quoteEndIdx + 2;
        }
        strOutBuff.append(output.substring(tempIdx));
        output = strOutBuff.toString();
        return output;
    }

    private static String toLower(String input) {
        String inputString = input != null ? input.toLowerCase(Locale.ROOT) : "";
        return inputString;
    }

    public static String positionInfo(ParserRuleContext ctx) {
        if (ctx != null && ctx.getStart() != null) {
            return String.format(Locale.ROOT, "token: %s,line: %d,position: %d", ctx.getStart().getText(), ctx.getStart().getLine(), ctx.getStart().getCharPositionInLine());
        }
        return "context is null";
    }
}

