/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle;

import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import java.util.HashMap;
import java.util.Map;

public class DWSConfig
extends ConvertConfig {
    public static final String DWS_CONVERTOR_PROPERTIES = "antlr-features-oracle.properties";
    public static final String PARAM_CONFIG_FLAG = "param.config.flag";
    public static final String TABLE_INDEX_RENAME = "table.index.rename";
    public static final String TABLE_CONSTRAINT_RENAME = "table.constraint.rename";
    public static final String TABLE_FOREIGN_KEY_COMMENT = "table.foreign.key.comment";
    public static final String TABLE_STORAGE_PARA_COMMENT = "table.storage.para.comment";
    public static final String TABLE_PLSQL_EXCEPTION = "table.plsql.exception";
    public static final String TABLE_CREATE_INSENSITIVE = "table.create.inSensitive";
    public static final String TABLE_PLSQL_PKGCONVERT = "table.plsql.pkgConvert";

    public static DWSConfig buildConfig() {
        return DWSConfig.buildConfig(DWS_CONVERTOR_PROPERTIES);
    }

    public static DWSConfig buildConfig(String configFile) {
        ConvertConfig defaults = ConvertConfig.buildConfig();
        ConvertConfig config = DWSConfig.loadConfig(configFile);
        DWSConfig dwsConfig = new DWSConfig();
        dwsConfig.merge(defaults);
        dwsConfig.merge(config);
        return dwsConfig;
    }

    public static Map<String, DWSConfig> loadTableConfigs() {
        HashMap<String, DWSConfig> tableConfigs = new HashMap<String, DWSConfig>();
        Map<String, ConvertConfig> cfs = DWSConfig.loadTableConfigs(DWS_CONVERTOR_PROPERTIES);
        cfs.entrySet().stream().forEach(et -> {
            DWSConfig dwsConfig = new DWSConfig();
            dwsConfig.merge((ConvertConfig)et.getValue());
            tableConfigs.put((String)et.getKey(), dwsConfig);
        });
        return tableConfigs;
    }
}

