/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle;

import com.huawei.hwclouds.migration.common.config.PropertyLoader;
import com.huawei.hwclouds.migration.common.util.ParserRuntimeException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DWSMigrationService {
    private static final Logger LOGGER = LogManager.getLogger(DWSMigrationService.class);
    protected static final Map<String, String> CREATE_TYPE_MAP = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, String> GLOBAL_TEMP_MAP = new ConcurrentHashMap<String, String>(10);
    private static final Map<String, String> PACKAGE_NAME_MAP = new ConcurrentHashMap<String, String>(10);

    public static void writePropertiesData() {
        try {
            PropertyLoader.writePropertyFile("packageMapper", PACKAGE_NAME_MAP);
        }
        catch (ParserRuntimeException migExp) {
            LOGGER.error("Errored out while saving package and its corresponding function/procedure names.");
        }
    }

    public static Map<String, String> getPackageNameMap() {
        return new LinkedHashMap<String, String>(PACKAGE_NAME_MAP);
    }

    public static String getPackageReplacement(String pkgName) {
        return PACKAGE_NAME_MAP.get(pkgName);
    }

    public static void addPackageNameMap(String pkgName, String pkgNewName) {
        if (pkgNewName != null) {
            PACKAGE_NAME_MAP.put(pkgName, pkgNewName);
        }
    }

    public static Map<String, String> getCreateTypeMap() {
        return new LinkedHashMap<String, String>(CREATE_TYPE_MAP);
    }

    public static void addCreateTypeMap(String table, String tableReplacement) {
        CREATE_TYPE_MAP.put(table, tableReplacement);
    }

    public static void clearCreateTypeMap() {
        CREATE_TYPE_MAP.clear();
    }

    public static Map<String, String> getGlobalTempMap() {
        return new LinkedHashMap<String, String>(GLOBAL_TEMP_MAP);
    }

    public static void addGlobalTempMap(String table, String tableReplacement) {
        GLOBAL_TEMP_MAP.put(table, tableReplacement);
    }
}

