/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle;

import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.DatabaseConvertor;
import com.huawei.hwclouds.migration.common.config.ConvertConfig;
import com.huawei.hwclouds.migration.common.config.PropertyLoader;
import com.huawei.hwclouds.migration.oracle.DWSConfig;
import com.huawei.hwclouds.migration.oracle.DWSMigrationService;
import com.huawei.hwclouds.migration.oracle.UnParserContext;
import com.huawei.hwclouds.migration.oracle.model.PackageInfo;
import com.huawei.hwclouds.migration.oracle.nodes.SqlRoot;
import com.huawei.hwclouds.migration.oracle.parser.OracleEntranceParser;
import com.huawei.hwclouds.migration.oracle.util.ConfigUtil;
import com.huawei.hwclouds.migration.oracle.util.SqlDialect;
import com.huawei.hwclouds.migration.oracle.util.SqlString;
import com.huawei.hwclouds.migration.oracle.writer.SqlPrettyWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OracleConvertor
implements DatabaseConvertor {
    private static final Logger LOGGER = LogManager.getLogger(OracleConvertor.class);
    private SqlRoot root = null;
    private SqlDialect dialect = SqlDialect.DWS;
    private DWSConfig defaultConfig;
    private Map<String, ConvertConfig> tableConfigs = new HashMap<String, ConvertConfig>();

    public OracleConvertor(Map<String, DWSConfig> configs) {
        this(null, configs);
    }

    public OracleConvertor(DWSConfig dwsConfig, Map<String, DWSConfig> configs) {
        this.defaultConfig = dwsConfig == null ? DWSConfig.buildConfig() : dwsConfig;
        Map<String, DWSConfig> tableDefaultConfigs = DWSConfig.loadTableConfigs();
        for (Map.Entry<String, DWSConfig> et : tableDefaultConfigs.entrySet()) {
            this.tableConfigs.put(et.getKey().toUpperCase(Locale.US), et.getValue().clone().merge(this.defaultConfig));
        }
        if (configs != null) {
            for (Map.Entry<String, DWSConfig> et : configs.entrySet()) {
                this.tableConfigs.put(et.getKey().toUpperCase(Locale.US), et.getValue().clone().merge(this.defaultConfig));
            }
        }
    }

    public void parse(String sql) throws ParserException {
        OracleEntranceParser parser = new OracleEntranceParser();
        this.root = parser.parse(sql);
    }

    public SqlString convert() throws ParserException {
        ConvertConfig config;
        if (this.root == null) {
            throw new ParserException("No Parse Sql Defined");
        }
        UnParserContext context = new UnParserContext();
        SqlPrettyWriter writer = new SqlPrettyWriter(this.dialect, this.defaultConfig, this.tableConfigs);
        this.root.unParse(writer, context);
        if (context.getPackageInfo() != null && context.getPackageInfo().getColumnMapList().size() > 0) {
            try {
                this.writerPackageMapper(context.getPackageInfo());
            }
            catch (IOException e) {
                LOGGER.error("Get package mapper error");
            }
        }
        if (ConfigUtil.getConfigValue(config = writer.getConfig("param.config.flag"), "table.plsql.pkgConvert", "false").equalsIgnoreCase("true")) {
            return this.doPkgConvert(writer);
        }
        return writer.toSqlString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlString doPkgConvert(SqlPrettyWriter writer) {
        String s = writer.toSqlString().toString();
        String filePath = PropertyLoader.getPropertyFileName("packageMapper").toString();
        File propFile = null;
        filePath = FilenameUtils.normalize((String)filePath);
        propFile = new File(filePath);
        BufferedReader reader = null;
        if (propFile.exists() && propFile.canWrite()) {
            try {
                reader = new BufferedReader(new FileReader(filePath));
                String line = null;
                HashMap<String, String> map = new HashMap<String, String>();
                while ((line = reader.readLine()) != null) {
                    String[] keyValue = line.split("=");
                    if (keyValue.length == 2) {
                        String key = keyValue[0];
                        String value = keyValue[1];
                        map.put(key, value);
                    }
                    s = this.doResSqlReplace(map, s);
                }
            }
            catch (IOException e) {
                LOGGER.error("Package convert failed");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("BufferedReader closed failed");
                    }
                }
            }
        }
        return new SqlString(this.dialect, s);
    }

    private String doResSqlReplace(Map<String, String> map, String s) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            s = s.replaceAll(entry.getKey(), entry.getValue());
        }
        return s;
    }

    private void writerPackageMapper(PackageInfo packageInfo) throws IOException {
        Map<String, String> columnMapList = packageInfo.getColumnMapList();
        Set<String> stringSet = columnMapList.keySet();
        for (String key : stringSet) {
            DWSMigrationService.addPackageNameMap(key, columnMapList.get(key));
        }
        DWSMigrationService.writePropertiesData();
    }

    public void reset() {
        this.root = new SqlRoot();
    }
}

