/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.huawei.db.migration.exception.ParserException;
import com.huawei.db.migration.interfaces.ISqlString;
import com.huawei.hwclouds.migration.oracle.OracleConvertor;
import com.huawei.hwclouds.migration.oracle.config.OraclePropertyLoader;
import com.huawei.hwclouds.migration.oracle.util.SqlString;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SingleClauseConvert {
    private static final Logger LOGGER = LogManager.getLogger(SingleClauseConvert.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(String originSql, Map propMap) throws ParserException, IOException {
        OracleConvertor convertor = new OracleConvertor(null);
        if (propMap == null) {
            propMap = new HashMap<String, String>();
        }
        StringBuilder sb = new StringBuilder();
        String line = originSql;
        try {
            OraclePropertyLoader.loadPropertyMap(propMap);
            sb.append(line);
            convertor.reset();
            convertor.parse(sb.toString());
            ISqlString str = convertor.convert();
            sb.delete(0, sb.length());
            String beforeFormat = str.toString().replaceAll("\\s+", "");
            String afterFormat = SqlFormatter.format((String)str.toString()).replaceAll("\\s+", "");
            if (beforeFormat.equalsIgnoreCase(afterFormat)) {
                String string = SqlString.handleErrorRes(SqlFormatter.format((String)str.toString()));
                return string;
            }
            String string = str.toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Can't Convert The Sql \n" + line);
            String string = "/* sql not support\r\n" + line + "\r\n*/;";
            return string;
        }
        finally {
            OraclePropertyLoader.clearPropMapCxt();
        }
    }
}

