/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.model;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum SqlTypeName {
    INT("INT"),
    INTEGER("INTEGER"),
    SMALLINT("SMALLINT"),
    LONG("LONG"),
    LONG_RAW("LONGRAW"),
    RAW("RAW"),
    BOOLEAN("BOOLEAN"),
    DECIMAL("DECIMAL"),
    NUMERIC("NUMERIC"),
    DEC("DEC"),
    CHARACTER("CHARACTER"),
    CHAR("CHAR"),
    NCHAR("NCHAR"),
    VARCHAR2("VARCHAR2"),
    VARCHAR("VARCHAR"),
    NVARCHAR2("NVARCHAR2"),
    STRING("STRING"),
    NUMBER("NUMBER"),
    FLOAT("FLOAT"),
    BINARY_FLOAT("BINARY_FLOAT"),
    BINARY_DOUBLE("BINARY_DOUBLE"),
    REAL("REAL"),
    DOUBLE_PRECISION("DOUBLEPRECISION"),
    DATE("DATE"),
    TIMESTAMP("TIMESTAMP"),
    ROWID("ROWID"),
    UROWID("UROWID"),
    CLOB("CLOB"),
    NCLOB("NCLOB"),
    BLOB("BLOB"),
    BFILE("BFILE"),
    ANY("ANY"),
    UNKOWN("UNKOWN");

    private final String name;
    private static Map<String, SqlTypeName> sqlTypeNameMap;

    private SqlTypeName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SqlTypeName find(String name) {
        return sqlTypeNameMap.get(name.toUpperCase(Locale.ROOT));
    }

    static {
        sqlTypeNameMap = new HashMap<String, SqlTypeName>();
        for (SqlTypeName value : SqlTypeName.values()) {
            sqlTypeNameMap.put(value.name, value);
        }
    }
}

