/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.AlterAction;
import com.huawei.hwclouds.migration.oracle.model.AlterTableAddColumnAction;
import com.huawei.hwclouds.migration.oracle.model.AlterTableConstraint;
import com.huawei.hwclouds.migration.oracle.model.AlterTableDropColumnAction;
import com.huawei.hwclouds.migration.oracle.model.AlterTableModifyColumnAction;
import com.huawei.hwclouds.migration.oracle.model.AlterTableRenameColumnAction;
import com.huawei.hwclouds.migration.oracle.model.ColumnDefinition;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.TableConstraint;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SqlColumnDefinitionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SqlTableConstraintVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class ColumnClausesVisitor
extends AbstractVisitor<List<AlterAction>> {
    List<AlterAction> alterActions = new ArrayList<AlterAction>();

    @Override
    protected List<AlterAction> defaultResult() {
        return this.alterActions;
    }

    @Override
    public List<AlterAction> visitAddColumnClause(OracleParser.AddColumnClauseContext ctx) {
        AlterTableAddColumnAction action = new AlterTableAddColumnAction();
        SqlNodeList<ColumnDefinition> sqlColumnDefinitions = new SqlNodeList<ColumnDefinition>();
        for (int i = 0; i < ctx.columnDefinition().size(); ++i) {
            ColumnDefinition columnDefinition = (ColumnDefinition)new SqlColumnDefinitionVisitor().visit((ParseTree)ctx.columnDefinition(i));
            sqlColumnDefinitions.addNode(columnDefinition);
        }
        action.setColumns(sqlColumnDefinitions);
        this.alterActions.add(action);
        return this.defaultResult();
    }

    @Override
    public List<AlterAction> visitModifyColumnClauses(OracleParser.ModifyColumnClausesContext ctx) {
        AlterTableModifyColumnAction modifyColumnAction = new AlterTableModifyColumnAction();
        if (ctx.modifyColProperties() != null) {
            SqlNodeList<ColumnDefinition> sqlColumnDefinitions = new SqlNodeList<ColumnDefinition>();
            for (int i = 0; i < ctx.modifyColProperties().size(); ++i) {
                ColumnDefinition columnDefinition = (ColumnDefinition)new SqlColumnDefinitionVisitor().visit((ParseTree)ctx.modifyColProperties(i));
                sqlColumnDefinitions.addNode(columnDefinition);
            }
            modifyColumnAction.setColumns(sqlColumnDefinitions);
        }
        this.alterActions.add(modifyColumnAction);
        return this.defaultResult();
    }

    @Override
    public List<AlterAction> visitDropColumnClause(OracleParser.DropColumnClauseContext ctx) {
        AlterTableDropColumnAction dropColumnAction = new AlterTableDropColumnAction();
        if (ctx.SET() != null) {
            dropColumnAction.setUnused(true);
        }
        if (ctx.columnName() != null) {
            SqlNodeList<Identifier> columnNames = new SqlNodeList<Identifier>();
            for (int i = 0; i < ctx.columnName().size(); ++i) {
                columnNames.addNode(new Identifier(ctx.columnName().get(i).getText()));
            }
            dropColumnAction.setColumnName(columnNames);
        }
        if (ctx.CASCADE() != null) {
            dropColumnAction.setCascadeType("CASCADE CONSTRAINTS");
        }
        if (ctx.INVALIDATE() != null) {
            dropColumnAction.setCascadeType("INVALIDATE");
        }
        this.alterActions.add(dropColumnAction);
        return this.defaultResult();
    }

    @Override
    public List<AlterAction> visitConstraintClauses(OracleParser.ConstraintClausesContext ctx) {
        ArrayList<TableConstraint> list;
        TableConstraint tableConstraint;
        int i;
        AlterTableConstraint sqlAlterTableConstraint = new AlterTableConstraint();
        if (ctx.outOfLineConstraint() != null && ctx.outOfLineConstraint().size() > 0) {
            sqlAlterTableConstraint.setOptions("ADD");
            ArrayList<TableConstraint> tableConstraints = new ArrayList<TableConstraint>();
            for (i = 0; i < ctx.outOfLineConstraint().size(); ++i) {
                tableConstraint = (TableConstraint)new SqlTableConstraintVisitor().visit((ParseTree)ctx.outOfLineConstraint(i));
                tableConstraints.add(tableConstraint);
            }
            sqlAlterTableConstraint.setTableConstraints(tableConstraints);
        }
        if (ctx.modifyConstraintClause() != null) {
            list = new ArrayList<TableConstraint>();
            sqlAlterTableConstraint.setOptions("MODIFY");
            TableConstraint tableConstraint2 = (TableConstraint)new SqlTableConstraintVisitor().visit((ParseTree)ctx.modifyConstraintClause());
            list.add(tableConstraint2);
        }
        if (ctx.oldConstraintName() != null) {
            sqlAlterTableConstraint.setOptions("RENAME");
            sqlAlterTableConstraint.setConstraintName(new Identifier(ctx.oldConstraintName().getText()));
            sqlAlterTableConstraint.setNewConstraintName(new Identifier(ctx.newConstraintName().getText()));
        }
        if (ctx.dropConstraintClause() != null && ctx.dropConstraintClause().size() > 0) {
            sqlAlterTableConstraint.setOptions("DROP");
            list = new ArrayList();
            for (i = 0; i < ctx.dropConstraintClause().size(); ++i) {
                tableConstraint = (TableConstraint)new SqlTableConstraintVisitor().visit((ParseTree)ctx.dropConstraintClause(i).dropPrimaryKeyOrUniqueOrGenericClause());
                list.add(tableConstraint);
            }
            sqlAlterTableConstraint.setTableConstraints(list);
        }
        this.alterActions.add(sqlAlterTableConstraint);
        return this.defaultResult();
    }

    @Override
    public List<AlterAction> visitRenameColumnClause(OracleParser.RenameColumnClauseContext ctx) {
        AlterTableRenameColumnAction sqlAlterTableRenameColumn = new AlterTableRenameColumnAction();
        sqlAlterTableRenameColumn.setNewColumn(ctx.newColumnName().getText());
        sqlAlterTableRenameColumn.setOldColumn(ctx.oldColumnName().getText());
        this.alterActions.add(sqlAlterTableRenameColumn);
        return this.defaultResult();
    }
}

