/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.BindVariable;
import com.huawei.hwclouds.migration.oracle.model.BindVariableOrDigit;
import com.huawei.hwclouds.migration.oracle.model.Constant;
import com.huawei.hwclouds.migration.oracle.model.GeneralElementPart;
import com.huawei.hwclouds.migration.oracle.model.IntervalConstant;
import com.huawei.hwclouds.migration.oracle.model.TimestampConstant;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.BindVariableVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.GeneralElementPartVisitor;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class ConstantVisitor
extends AbstractVisitor<Constant> {
    private Constant constant = new Constant();

    @Override
    protected Constant defaultResult() {
        return this.constant;
    }

    @Override
    public Constant visitTimestampConstant(OracleParser.TimestampConstantContext ctx) {
        TimestampConstant timestampConstant = new TimestampConstant();
        if (ctx.stampString != null) {
            timestampConstant.setStampString(ctx.stampString.getText());
        } else {
            timestampConstant.setStampVariable((BindVariable)new BindVariableVisitor().visit((ParseTree)ctx.bindVariable()));
        }
        if (ctx.zoneString != null) {
            timestampConstant.setZoneString(ctx.zoneString.getText());
        }
        this.constant.setTimestampConstant(timestampConstant);
        return this.defaultResult();
    }

    @Override
    public Constant visitIntervalConstant(OracleParser.IntervalConstantContext ctx) {
        IntervalConstant intervalConstant = new IntervalConstant();
        if (ctx.quotedString() != null) {
            intervalConstant.setIntervalString(ctx.quotedString().getText());
        }
        if (ctx.bindVariable() != null) {
            intervalConstant.setIntervalVariable((BindVariable)new BindVariableVisitor().visit((ParseTree)ctx.bindVariable()));
        }
        if (ctx.generalElementPart() != null) {
            intervalConstant.setIntervalPart((GeneralElementPart)new GeneralElementPartVisitor().visit((ParseTree)ctx.generalElementPart()));
        }
        intervalConstant.setDateType(ctx.dateType().getText());
        if (ctx.bindVariableOrDigitList() != null) {
            List<OracleParser.BindVariableOrDigitContext> contexts = ctx.bindVariableOrDigitList().bindVariableOrDigit();
            ArrayList<BindVariableOrDigit> bindVariableOrDigits = new ArrayList<BindVariableOrDigit>();
            for (OracleParser.BindVariableOrDigitContext context : contexts) {
                bindVariableOrDigits.add(this.getBindVariableOrDigit(context));
            }
            intervalConstant.setBindVariableOrDigits(bindVariableOrDigits);
        }
        intervalConstant.setToDay(ctx.DAY() != null);
        intervalConstant.setToHour(ctx.HOUR() != null);
        intervalConstant.setToMinute(ctx.MINUTE() != null);
        intervalConstant.setToSecond(ctx.SECOND() != null);
        if (ctx.bindVariableOrDigit() != null) {
            intervalConstant.setSecBindOrDigit(this.getBindVariableOrDigit(ctx.bindVariableOrDigit()));
        }
        this.constant.setIntervalConstant(intervalConstant);
        return this.defaultResult();
    }

    private BindVariableOrDigit getBindVariableOrDigit(OracleParser.BindVariableOrDigitContext context) {
        BindVariableOrDigit bindVariableOrDigit = new BindVariableOrDigit();
        if (context.bindVariable() != null) {
            bindVariableOrDigit.setBindVariable((BindVariable)new BindVariableVisitor().visit((ParseTree)context.bindVariable()));
        } else {
            bindVariableOrDigit.setDigit(context.UNSIGNED_INTEGER().getText());
        }
        return bindVariableOrDigit;
    }

    @Override
    public Constant visitNumericConstant(OracleParser.NumericConstantContext ctx) {
        this.constant.setNumeric(ctx.numeric().getText());
        return this.defaultResult();
    }

    @Override
    public Constant visitDateConstant(OracleParser.DateConstantContext ctx) {
        this.constant.setDateConstant(ctx.quotedString().getText());
        return this.defaultResult();
    }

    @Override
    public Constant visitQuoteConstant(OracleParser.QuoteConstantContext ctx) {
        this.constant.setQuotedString(ctx.getText());
        return this.defaultResult();
    }

    @Override
    public Constant visitOtherConstant(OracleParser.OtherConstantContext ctx) {
        this.constant.setOtherConstant(ctx.getText());
        return this.defaultResult();
    }
}

