/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hwclouds.migration.oracle.parser.visitor;

import com.huawei.hwclouds.migration.oracle.model.CreateIndex;
import com.huawei.hwclouds.migration.oracle.model.Expression;
import com.huawei.hwclouds.migration.oracle.model.Identifier;
import com.huawei.hwclouds.migration.oracle.model.IndexColumnName;
import com.huawei.hwclouds.migration.oracle.model.IndexOptions;
import com.huawei.hwclouds.migration.oracle.model.TableName;
import com.huawei.hwclouds.migration.oracle.nodes.SqlNodeList;
import com.huawei.hwclouds.migration.oracle.parser.OracleParser;
import com.huawei.hwclouds.migration.oracle.parser.visitor.AbstractVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.ExpressionVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.SqlIndexOptionsVisitor;
import com.huawei.hwclouds.migration.oracle.parser.visitor.TableNameVisitor;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class CreateIndexVisitor
extends AbstractVisitor<CreateIndex> {
    private CreateIndex createIndex = new CreateIndex();

    @Override
    protected CreateIndex defaultResult() {
        return this.createIndex;
    }

    @Override
    public CreateIndex visitCreateIndex(OracleParser.CreateIndexContext ctx) {
        this.createIndex.setIndexName(new Identifier(ctx.indexName().getText()));
        if (ctx.UNIQUE() != null) {
            this.createIndex.setIndexType("UNIQUE");
        }
        if (ctx.BITMAP() != null) {
            this.createIndex.setIndexType("BITMAP");
        }
        if (ctx.tableIndexClause() != null) {
            OracleParser.TableIndexClauseContext tableIndexClause = ctx.tableIndexClause();
            this.dealWithTableIndexClause(tableIndexClause);
        }
        if (ctx.clusterIndexClause() != null) {
            OracleParser.ClusterIndexClauseContext clusterIndexClause = ctx.clusterIndexClause();
            TableName clusterName = (TableName)new TableNameVisitor().visit((ParseTree)clusterIndexClause);
            this.createIndex.setClusterName(clusterName);
            if (clusterIndexClause.indexAttributes() != null) {
                SqlNodeList<IndexOptions> options = new SqlNodeList<IndexOptions>();
                for (int i = 0; i < ctx.clusterIndexClause().indexAttributes().size(); ++i) {
                    IndexOptions indexOptions = (IndexOptions)new SqlIndexOptionsVisitor().visit((ParseTree)clusterIndexClause.indexAttributes().get(i));
                    options.addNode(indexOptions);
                }
                this.createIndex.setOptions(options);
            }
        }
        if (ctx.bitmapJoinIndexClause() != null) {
            OracleParser.BitmapJoinIndexClauseContext bitmapJoinIndexClause = ctx.bitmapJoinIndexClause();
            this.dealWithBitmapJoinIndexClause(bitmapJoinIndexClause);
        }
        if (ctx.USABLE() != null) {
            this.createIndex.setSpecialType("USABLE");
        }
        if (ctx.UNUSABLE() != null) {
            this.createIndex.setSpecialType("UNUSABLE");
        }
        return this.defaultResult();
    }

    private void dealWithBitmapJoinIndexClause(OracleParser.BitmapJoinIndexClauseContext bitmapJoinIndexClause) {
        TableName tableName = (TableName)new TableNameVisitor().visit((ParseTree)bitmapJoinIndexClause.tableviewName());
        this.createIndex.setTableName(tableName);
        List<OracleParser.IndexColumnNameContext> indexColumnNames = bitmapJoinIndexClause.indexColumnName();
        SqlNodeList<IndexColumnName> indexColumns = new SqlNodeList<IndexColumnName>();
        for (int i = 0; i < indexColumnNames.size(); ++i) {
            OracleParser.IndexColumnNameContext indexColumnNameContext = indexColumnNames.get(i);
            IndexColumnName indexColumnName = new IndexColumnName();
            if (indexColumnNameContext.tableviewName() != null) {
                indexColumnName.setTableName((TableName)new TableNameVisitor().visit((ParseTree)indexColumnNameContext.tableviewName()));
            }
            if (indexColumnNameContext.tableAlias() != null) {
                indexColumnName.setTableNameAlias(indexColumnNameContext.tableAlias().getText());
            }
            indexColumnName.setColumnName(new Identifier(indexColumnNameContext.columnName().getText()));
            if (indexColumnNameContext.ASC() != null) {
                indexColumnName.setSortType(IndexColumnName.SortType.ASC);
            }
            if (indexColumnNameContext.DESC() != null) {
                indexColumnName.setSortType(IndexColumnName.SortType.DESC);
            }
            indexColumns.addNode(indexColumnName);
        }
        this.createIndex.setIndexColumns(indexColumns);
    }

    public void dealWithTableIndexClause(OracleParser.TableIndexClauseContext tableIndexClause) {
        TableName tableName = (TableName)new TableNameVisitor().visit((ParseTree)tableIndexClause.tableviewName());
        this.createIndex.setTableName(tableName);
        if (tableIndexClause.tableAlias() != null) {
            this.createIndex.setTableNameAlias(tableIndexClause.tableAlias().getText());
        }
        List<OracleParser.IndexExprClauseContext> indexExprClauseContexts = tableIndexClause.indexExprClause();
        SqlNodeList<IndexColumnName> indexColumns = new SqlNodeList<IndexColumnName>();
        for (int i = 0; i < indexExprClauseContexts.size(); ++i) {
            IndexColumnName indexColumnName = new IndexColumnName();
            OracleParser.IndexExprContext indexExprContext = indexExprClauseContexts.get(i).indexExpr();
            if (indexExprContext.columnName() != null) {
                indexColumnName.setExpression(false);
                indexColumnName.setColumnName(new Identifier(indexExprContext.columnName().getText()));
            } else {
                indexColumnName.setExpression(true);
                indexColumnName.setExpressionValue((Expression)new ExpressionVisitor().visit((ParseTree)indexExprContext.expression()));
            }
            if (indexExprClauseContexts.get(i).ASC() != null) {
                indexColumnName.setSortType(IndexColumnName.SortType.ASC);
            }
            if (indexExprClauseContexts.get(i).DESC() != null) {
                indexColumnName.setSortType(IndexColumnName.SortType.DESC);
            }
            indexColumns.addNode(indexColumnName);
        }
        this.createIndex.setIndexColumns(indexColumns);
        if (tableIndexClause.indexProperties() != null) {
            IndexOptions indexOptions;
            SqlNodeList<IndexOptions> options = new SqlNodeList<IndexOptions>();
            if (tableIndexClause.indexProperties().globalPartitionedIndex() != null) {
                for (int i = 0; i < tableIndexClause.indexProperties().globalPartitionedIndex().size(); ++i) {
                    indexOptions = (IndexOptions)new SqlIndexOptionsVisitor().visit((ParseTree)tableIndexClause.indexProperties().globalPartitionedIndex().get(i));
                    options.addNode(indexOptions);
                }
            }
            if (tableIndexClause.indexProperties().localPartitionedIndex() != null) {
                for (int i = 0; i < tableIndexClause.indexProperties().localPartitionedIndex().size(); ++i) {
                    indexOptions = (IndexOptions)new SqlIndexOptionsVisitor().visit((ParseTree)tableIndexClause.indexProperties().localPartitionedIndex().get(i));
                    options.addNode(indexOptions);
                }
            }
            if (tableIndexClause.indexProperties().indexAttributes() != null) {
                for (int i = 0; i < tableIndexClause.indexProperties().indexAttributes().size(); ++i) {
                    indexOptions = (IndexOptions)new SqlIndexOptionsVisitor().visit((ParseTree)tableIndexClause.indexProperties().indexAttributes().get(i));
                    options.addNode(indexOptions);
                }
            }
            this.createIndex.setOptions(options);
        }
    }
}

